package com.thebeastshop.kit.flowable;

import com.thebeastshop.common.utils.FileUtil;
import com.thebeastshop.common.utils.MD5Util;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Bryan.Zhang
 * @Date 2019-06-06
 */
public class FlowableBPMScanner implements InitializingBean {

    private final Logger log = LoggerFactory.getLogger(getClass());

    private static final String DIGEST_PATH_LINUX = "/data/appdatas/flowable/";

    private static final String DIGEST_PATH_WIN = "C:/data/appdatas/flowable/";

    private static final String DIGEST_FILE = "bpm_digest.txt";

    private static final String OS = System.getProperty("os.name").toLowerCase();

    private String location = "classpath:flowable/*.xml";

    private FlowableEngine flowableEngine;

    @Override
    public void afterPropertiesSet() throws Exception {
        log.info("[FLOWABLE]开始扫描[{}]的变动流程资源文件",location);
        if (StringUtils.isBlank(location)) {
            return;
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        Resource[] resources = resolver.getResources(location);

        Map<String, String> digestMap = getDigest();
        String content;
        String md5Str;
        boolean isChange = false;
        for (Resource resource : resources) {
            content = IOUtils.toString(resource.getURI(),"UTF-8");
            md5Str = MD5Util.makeMD5(content);
            if(StringUtils.isBlank(digestMap.get(resource.getFilename())) || !md5Str.equals(digestMap.get(resource.getFilename()))){
                log.info("[FLOWABLE]开始部署流程资源文件{}",resource.getFilename());
                digestMap.put(resource.getFilename(),md5Str);
                flowableEngine.deploy(getProjectPath(resource.getFile().getPath()),resource.getFilename(),getAppName());
                isChange = true;
            }
        }

        if (isChange){
            log.info("[FLOWABLE]写入摘要文件");
            String dir = getFileDir();
            if(!FileUtil.exists(dir)){
                FileUtil.createDirectory(dir);
            }
            List<String> writeList = new ArrayList<>();
            digestMap.forEach((k, v) -> writeList.add(k + "," + v));
            FileUtil.writeList2File(writeList,dir + DIGEST_FILE);
        }else{
            log.info("[FLOWABLE]没有扫描到发生改变的资源文件");
        }
    }

    private Map<String, String> getDigest(){
        try{
            List<String> digestList = FileUtil.readFile2List(getFileDir() + DIGEST_FILE);
            Map<String,String> map = new HashMap<>();

            digestList.forEach(s -> {
                String[] array = s.split(",");
                map.put(array[0],array[1]);
            });
            return map;
        }catch (Throwable t){
            return new HashMap<>();
        }
    }

    private String getFileDir(){
        String digestPath;
        if(OS.equals("win")){
            digestPath = DIGEST_PATH_WIN;
        }else{
            digestPath = DIGEST_PATH_LINUX;
        }
        return digestPath;
    }

    private String getAppName() {
        String appName;
        String str = System.getProperty("user.dir");
        appName = str.substring(str.lastIndexOf(File.separator)+1);
        return appName;
    }

    private String getProjectPath(String filePath){
        String word = "classes/";
        if(filePath.indexOf(word) == -1){
            return filePath;
        }
        return filePath.substring(filePath.lastIndexOf(word) + word.length());
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public FlowableEngine getFlowableEngine() {
        return flowableEngine;
    }

    public void setFlowableEngine(FlowableEngine flowableEngine) {
        this.flowableEngine = flowableEngine;
    }
}
