/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.common.enums;

/**
 * @author Paul-xiong
 * @date 2017年8月7日
 * @description 文件类型
 */
public enum FileTypeEnum implements CodeEnum<Integer> {
	JPG(0, "jpg"),
	PNG(1, "png"),
	GIF(2, "gif"),
	WAV(3, "wav"),
	MP3(4, "mp3"),
	MP4(5, "mp4"),
	AVI(6, "avi"),
	ZIP(7, "zip"),
	PDF(8, "pdf"),
	AAC(9, "aac"),
	XML(10, "xml")
	;

	public final int code;
	public final String name;

	FileTypeEnum(final int code, final String name) {
		this.code = code;
		this.name = name;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	public static FileTypeEnum getEnumByCode(Integer code) {
		for (FileTypeEnum e : FileTypeEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	public static FileTypeEnum getEnumByName(String name) {
		for (FileTypeEnum e : FileTypeEnum.values()) {
			if (e.getName().equalsIgnoreCase(name)) {
				return e;
			}
		}
		return null;
	}

}
