package com.thebeastshop.common.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * 生日礼状态枚举
 * @author LK
 *
 */
public enum ShareTypeEnum {
	ARTICLE(1, "专题ID"),
	PRODUCT(5, "商品Code"),
	STORY(6, "封面故事ID"),
	GROUP(7, "团购CODE"),
	POINT(10, "积分兑换商城")
	;

	public final Integer status;
	public final String desc;

	public static final List<ShareTypeEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private ShareTypeEnum(final Integer status, final String desc) {
		this.status = status;
		this.desc = desc;
	}

	 // 普通方法
    public static String getDesc(int status) {

        for (ShareTypeEnum c : ALL) {
            if (c.getStatus() == status) {
                return c.desc;
            }
        }
        return null;
    }

	public Integer getStatus() {
		return status;
	}

	public String getDesc() {
		return desc;
	}

}
