package com.thebeastshop.common.enums;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Predicate;

public enum MemberLevelEnum implements CodeEnum<Integer> {
	NORMAL(-1, 10, "注册用户", "注册", new BigDecimal("1.00"), new BigDecimal("1.00"), "https://img.thebeastshop.com/app/message/member_icon0.png", "member/privilege/level-icon/level-zero.jpg", new BigDecimal("0.00"), null, null, "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-zero.jpg"),
	VIP(0, 20, "松鼠会员", "松鼠", new BigDecimal("1.00"), new BigDecimal("0.95"), "https://img.thebeastshop.com/app/message/member_icon1.png", "member/privilege/level-icon/level-one.jpg", new BigDecimal("1"), null, "您已享受松鼠会员生日9.5折", "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-one.jpg"),
	VIP1(4, 30, "兔子会员", "兔子", new BigDecimal("1.00"), new BigDecimal("0.95"), "https://img.thebeastshop.com/app/message/member_icon5.png", "member/privilege/level-icon/level-five.jpg", new BigDecimal("3000.00"), "您已享受兔子会员折扣95折", "您已享受兔子会员生日95折", "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-five.jpg"),
	VIP2(1, 40, "小猫会员", "小猫", new BigDecimal("0.95"), new BigDecimal("0.90"), "https://img.thebeastshop.com/app/message/member_icon2.png", "member/privilege/level-icon/level-two.jpg", new BigDecimal("5000.00"), "您已享受小猫会员折扣9.5折", "您已享受小猫会员生日9折", "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-two.jpg"),
	VIP3(2, 50, "老虎会员", "老虎", new BigDecimal("0.90"), new BigDecimal("0.85"), "https://img.thebeastshop.com/app/message/member_icon4.png", "member/privilege/level-icon/level-three.jpg", new BigDecimal("10000.00"), "您已享受老虎会员折扣9折", "您已享受老虎会员生日8.5折", "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-three.jpg"),
	VIP4(3, 60, "大象会员", "大象", new BigDecimal("0.90"), new BigDecimal("0.80"), "https://img.thebeastshop.com/app/message/member_icon3.png", "member/privilege/level-icon/level-four.jpg", new BigDecimal("50000.00"), "您已享受大象会员折扣9折", "您已享受大象会员生日8折", "https://img.thebeastshop.com/member/privilege/upgrade-icon/level-four.jpg"),
	;

	private final int code;

	private final int level;
	private final String name;

	private final String shortName;
	private final BigDecimal levelAmountCondition;

	private final BigDecimal bdayDiscountRatio;
	private final String messageImage;
	private final String avatarUrl;

	private final String upgradeUrl;
	private final BigDecimal threshold;
	private final String description;
	private final String bdDescription;

	private String startTime = "2017-07-31 00:00:00";
	private String endTime = "2017-08-31 23:59:59";

	public static final List<MemberLevelEnum> ALL = Collections.unmodifiableList(Arrays.asList(values()));

	private MemberLevelEnum(int code, int level, String name, String shortName, BigDecimal levelAmountCondition, BigDecimal bdayDiscountRatio,
							String messageImage, String avatarUrl, BigDecimal threshold, String description, String bdDescription, String upgradeUrl) {
		this.code = code;
		this.level = level;
		this.name = name;
		this.shortName = shortName;
		this.levelAmountCondition = levelAmountCondition;
		this.bdayDiscountRatio = bdayDiscountRatio;
		this.avatarUrl = "https://img.thebeastshop.com/" + avatarUrl;
		this.messageImage = messageImage;
		this.threshold = threshold;
		this.description = description;
		this.bdDescription = bdDescription;
		this.upgradeUrl = upgradeUrl;
	}

	public Integer getCode() {
		return code;
	}

	public String getName() {
		return name;
	}

	public BigDecimal getLevelAmountCondition() {

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			Date start = sdf.parse(startTime);
			Date end = sdf.parse(endTime);
			Date now = new Date();
			if (now.after(start) && now.before(end)) {
				if (levelAmountCondition.equals(new BigDecimal("0.90")))
					return new BigDecimal("0.88");
			}

		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return levelAmountCondition;
	}

	public static MemberLevelEnum getEnumByCode(Integer code) {
		for (MemberLevelEnum e : MemberLevelEnum.values()) {
			if (e.getCode().equals(code)) {
				return e;
			}
		}
		return null;
	}

	public String getMessageImage() {
		return messageImage;
	}

	public String getAvatarUrl() {
		return avatarUrl;
	}

	public BigDecimal getThreshold() {
		return threshold;
	}

	public int getLevel() {
		return level;
	}

	public BigDecimal getBdayDiscountRatio() {
		return bdayDiscountRatio;
	}

	public String getDescription() {

		try {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			Date start = sdf.parse(startTime);
			Date end = sdf.parse(endTime);
			Date now = new Date();
			if (now.after(start) && now.before(end)) {
				if (code == 2) {
					return "老虎会员专享88折（7.31~8.31）";
				}
				if (code == 3) {
					return "大象会员专享88折（7.31~8.31）";
				}
			}

		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return description;
	}

	public String getBdDescription() {
		return bdDescription;
	}

	@Override
	public String toString() {
		return this.getCode().toString();
	}

	public static int getLevelByCode(int code){
		MemberLevelEnum memberLevelEnum = getEnumByCode(code);
		if(memberLevelEnum == null){
			throw new RuntimeException("没有这个会员类型ID["+code+"]");
		}
		return memberLevelEnum.getLevel();
	}

	public static MemberLevelEnum getNextLevelEnumByCode(int code){
		MemberLevelEnum originalLevelEnum = getEnumByCode(code);
		if (originalLevelEnum == null){
			throw new RuntimeException("没有这个会员类型ID["+code+"]");
		}

		MemberLevelEnum nextLevelEnum = Arrays.stream(MemberLevelEnum.values())
				.filter(memberLevelEnum ->
						memberLevelEnum.getLevel() > originalLevelEnum.getLevel())
				.min(Comparator.comparingInt(MemberLevelEnum::getLevel)).orElse(null);
		return nextLevelEnum;
	}

	public static MemberLevelEnum getPreLevelEnumByCode(int code){
		MemberLevelEnum originalLevelEnum = getEnumByCode(code);
		if (originalLevelEnum == null){
			throw new RuntimeException("没有这个会员类型ID["+code+"]");
		}

		MemberLevelEnum preLevelEnum = Arrays.stream(MemberLevelEnum.values())
				.filter(memberLevelEnum -> memberLevelEnum.getLevel() < originalLevelEnum.getLevel())
				.min((o1, o2) -> o2.getLevel() - o1.getLevel()).orElse(null);
		return preLevelEnum;
	}

	public static void main(String[] args) {
		System.out.println(MemberLevelEnum.VIP1.getShortName());
	}

	public String getShortName() {
		return shortName;
	}

	public String getUpgradeUrl() {
		return upgradeUrl;
	}
}
