package com.thebeastshop.kit.codetemplate;

import com.thebeastshop.kit.codetemplate.utils.CodeGenerator;

import javax.annotation.PostConstruct;
import java.util.Enumeration;
import java.util.ResourceBundle;

public class CodeTemplateInitProcessor {

    @PostConstruct
    public void codeGeneratorTemplateInit(){
        ResourceBundle config = ResourceBundle.getBundle("code");
        Enumeration<String> codeTempNames = config.getKeys();
        CodeGenerator codeGenerator = CodeGenerator.getInstance();
        while (codeTempNames.hasMoreElements()){
            String codeTemplateName = codeTempNames.nextElement();
            try {
                codeGenerator.addCodeTemplate(codeTemplateName,config.getString(codeTemplateName));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
