package com.thebeastshop.kit.codetemplate;


import com.thebeastshop.kit.codetemplate.utils.CodeGenerator;
import com.thebeastshop.kit.prop.PropPatternProcessor;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2018-05-21 15:49
 */
public class CodePropProccessor extends PropPatternProcessor {

    public final static String PROP_PREFIX = "code.template";

    public CodePropProccessor() {
        setPrefix(PROP_PREFIX);
    }

    @Override
    public void process(String propName, Object value) {
        if (value == null) {
            return;
        }
        CodeGenerator.getInstance().addCodeTemplate(propName, value.toString());
    }
}
