/*
 * Decompiled with CFR 0.152.
 */
package com.thebeast.kit.alitool;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.thebeast.kit.alitool.FileConstant;
import com.thebeast.kit.alitool.FileInfo;
import com.thebeast.kit.alitool.FileUploadResp;
import com.thebeast.kit.alitool.MimeType;
import com.thebeastshop.common.enums.FileTypeEnum;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BASE_PATH = "file/";
    private static final String KEY_PDF = "pdf/";
    private OSSClient ossClient;
    private String ossEndPoint;
    private String ossAccessId;
    private String ossAccessKey;
    private String ossBucketName;
    private String baseUrl;
    private final String KEY_IMG = "image/";
    private static final String KEY_FILE = "document/";

    private String getKey(String fileUrl) {
        return fileUrl.replace(this.baseUrl, "");
    }

    private String buildExtraPath(String extraPath) {
        if (StringUtils.isNotBlank((String)extraPath)) {
            extraPath = extraPath.indexOf("/") == 0 ? extraPath.substring(1) : extraPath;
            extraPath = extraPath + (extraPath.lastIndexOf("/") == -1 ? "/" : "");
        } else {
            extraPath = "";
        }
        return extraPath;
    }

    private OSSClient getOssClient() {
        if (this.ossClient == null) {
            this.ossClient = new OSSClient(this.ossEndPoint, this.ossAccessId, this.ossAccessKey);
        }
        return this.ossClient;
    }

    public String getOssEndPoint() {
        return this.ossEndPoint;
    }

    public void setOssEndPoint(String ossEndPoint) {
        this.ossEndPoint = ossEndPoint;
    }

    public String getOssAccessId() {
        return this.ossAccessId;
    }

    public void setOssAccessId(String ossAccessId) {
        this.ossAccessId = ossAccessId;
    }

    public String getOssAccessKey() {
        return this.ossAccessKey;
    }

    public void setOssAccessKey(String ossAccessKey) {
        this.ossAccessKey = ossAccessKey;
    }

    public String getOssBucketName() {
        return this.ossBucketName;
    }

    public void setOssBucketName(String ossBucketName) {
        this.ossBucketName = ossBucketName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public FileUploadResp uploadFile(String localFilePath, String extraPath, FileTypeEnum fileType) {
        File file = new File(localFilePath);
        return this.uploadFile(file, extraPath, fileType);
    }

    public String uploadImg(String suffix, InputStream content) {
        String fileName = DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss") + StringUtil.getRandomString((int)6, (String)"0123456789");
        return this.uploadImg(fileName, suffix, content);
    }

    public String uploadImg(String fileName, String suffix, InputStream content) {
        String key = "image/" + fileName + "." + suffix;
        ObjectMetadata meta = new ObjectMetadata();
        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }
        this.logger.info("-------ossBucketName:" + this.ossBucketName);
        this.getOssClient().putObject(this.ossBucketName, key, content, meta);
        return key;
    }

    public String uploadFile(String subdirectory, String fileName, String suffix, InputStream content) {
        String key = KEY_FILE + (EmptyUtil.isNotEmpty((String)subdirectory) ? subdirectory + File.separator : "") + fileName + "." + suffix;
        ObjectMetadata meta = new ObjectMetadata();
        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }
        this.getOssClient().putObject(this.ossBucketName, key, content, meta);
        return key;
    }

    public String uploadFileNew(String subdirectory, String fileName, String suffix, InputStream content) throws URIException, UnsupportedEncodingException {
        String endCodefileName = URIUtil.encodePath((String)fileName, (String)StandardCharsets.UTF_8.name());
        StringBuilder keySb = new StringBuilder().append(KEY_FILE).append(EmptyUtil.isNotEmpty((String)subdirectory) ? subdirectory + File.separator : "").append(endCodefileName).append(".").append(suffix);
        ObjectMetadata meta = new ObjectMetadata();
        String objectName = URLEncoder.encode("\u6587\u4ef6\u5939/\u4e2d\u6587\u540d\u6587\u4ef6.txt", "UTF-8");
        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }
        PutObjectResult putObjectResult = this.getOssClient().putObject(this.ossBucketName, keySb.toString(), content, meta);
        this.logger.info("PutObjectResult: {}", (Object)JSON.toJSONString((Object)putObjectResult));
        return keySb.toString();
    }

    public FileInfo uploadFile(InputStream inputStream, String extraPath) throws IOException {
        try {
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) > -1) {
                baos.write(buffer, 0, len);
            }
            ByteArrayInputStream inputStreamc = new ByteArrayInputStream(baos.toByteArray());
            byte[] b = Arrays.copyOf(baos.toByteArray(), 28);
            String hex = FileUploadClient.bytes2Hex(b).toUpperCase();
            Set<String> keys = FileConstant.FILE_TYPE.keySet();
            ObjectMetadata meta = new ObjectMetadata();
            String extraPaths = extraPath.substring(extraPath.lastIndexOf(".") + 1, extraPath.length());
            this.logger.info("extraPaths={}", (Object)extraPaths);
            MimeType mimeType = MimeType.findByName(extraPaths);
            if (mimeType != null) {
                meta.setContentType(mimeType.getContentType());
            }
            this.getOssClient().putObject(this.ossBucketName, extraPath, (InputStream)inputStreamc, meta);
            FileInfo info = new FileInfo(inputStream, extraPath);
            inputStream.close();
            inputStreamc.close();
            baos.flush();
            baos.close();
            return info;
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
            inputStream.close();
            return null;
        }
    }

    public static String bytes2Hex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        String tmp = null;
        for (byte b : bytes) {
            tmp = Integer.toHexString(0xFF & b);
            if (tmp.length() == 1) {
                tmp = "0" + tmp;
            }
            sb.append(tmp);
        }
        return sb.toString();
    }

    public FileUploadResp uploadFile(File file, String extraPath, FileTypeEnum fileType) {
        FileUploadResp info = null;
        try {
            info = this.uploadFile((InputStream)new FileInputStream(file), extraPath, fileType);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25: {}", (Throwable)e);
        }
        return info;
    }

    public FileUploadResp uploadFile(InputStream inputStream, String extraPath, FileTypeEnum fileType) {
        FileUploadResp info = null;
        try {
            info = this.uploadFile(inputStream, extraPath, fileType, "");
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
        return info;
    }

    public FileUploadResp uploadFile(InputStream inputStream, String extraPath, String fileType) {
        return this.uploadFile(inputStream, extraPath, fileType, "");
    }

    public FileUploadResp uploadFile(File file, String extraPath, FileTypeEnum fileType, String fileName) {
        FileUploadResp info = null;
        try {
            info = this.uploadFile((InputStream)new FileInputStream(file), extraPath, fileType, fileName);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
        return info;
    }

    public FileUploadResp uploadFile(InputStream inputStream, String extraPath, FileTypeEnum fileType, String fileName) {
        FileUploadResp info = null;
        try {
            if (StringUtils.isBlank((String)fileName)) {
                fileName = UUID.randomUUID().toString().replace("-", "");
            }
            String key = BASE_PATH + this.buildExtraPath(extraPath) + fileName + "." + fileType.getName();
            this.getOssClient().putObject(this.ossBucketName, key, inputStream);
            info = new FileUploadResp(inputStream, this.baseUrl + key);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
        return info;
    }

    public FileUploadResp uploadFile(InputStream inputStream, String extraPath, String fileType, String fileName) {
        FileTypeEnum fileTypeEnum = FileTypeEnum.getEnumByName((String)fileType);
        if (fileTypeEnum == null) {
            throw new RuntimeException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301");
        }
        return this.uploadFile(inputStream, extraPath, fileTypeEnum, fileName);
    }

    public List<FileUploadResp> listFiles(String extraPath) {
        LinkedList<FileUploadResp> list = null;
        try {
            ObjectListing listing = this.getOssClient().listObjects(this.ossBucketName, BASE_PATH + this.buildExtraPath(extraPath));
            list = new LinkedList<FileUploadResp>();
            for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                list.add(this.getFile(this.baseUrl + objectSummary.getKey()));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u5f02\u5e38: {}", (Throwable)e);
        }
        return list;
    }

    public FileUploadResp getFile(String fileUrl) {
        FileUploadResp info = null;
        try {
            OSSObject ossObject = this.getOssClient().getObject(this.ossBucketName, this.getKey(fileUrl));
            info = new FileUploadResp(ossObject.getObjectContent(), fileUrl);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
        return info;
    }

    public void deleteFile(String fileUrl) {
        try {
            String key = this.getKey(fileUrl);
            this.getOssClient().deleteObject(this.ossBucketName, key);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
    }

    public String uploadPdf(String fileName, String suffix, InputStream content) {
        String key = KEY_PDF + fileName + "." + suffix;
        ObjectMetadata meta = new ObjectMetadata();
        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }
        this.getOssClient().putObject(this.ossBucketName, key, content, meta);
        return key;
    }

    public OSSObject downloadByKey(String key) {
        return this.getOssClient().getObject(this.ossBucketName, key);
    }

    public OSSObject download(String key) {
        return this.getOssClient().getObject(this.ossBucketName, key);
    }
}

