/*
 * Decompiled with CFR 0.152.
 */
package com.thebeast.kit.alitool;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.thebeast.kit.alitool.FileUploadResp;
import com.thebeast.kit.alitool.MimeType;
import com.thebeastshop.common.enums.FileTypeEnum;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadClient {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BASE_PATH = "file/";
    private OSSClient ossClient;
    private String ossEndPoint;
    private String ossAccessId;
    private String ossAccessKey;
    private String ossBucketName;
    private String baseUrl;
    private final String KEY_IMG = "image/";
    private static final String KEY_FILE = "document/";

    private String getKey(String fileUrl) {
        return fileUrl.replace(this.baseUrl, "");
    }

    private String buildExtraPath(String extraPath) {
        if (StringUtils.isNotBlank((String)extraPath)) {
            extraPath = extraPath.indexOf("/") == 0 ? extraPath.substring(1) : extraPath;
            extraPath = extraPath + (extraPath.lastIndexOf("/") == -1 ? "/" : "");
        } else {
            extraPath = "";
        }
        return extraPath;
    }

    private OSSClient getOssClient() {
        if (this.ossClient == null) {
            this.ossClient = new OSSClient(this.ossEndPoint, this.ossAccessId, this.ossAccessKey);
        }
        return this.ossClient;
    }

    public String getOssEndPoint() {
        return this.ossEndPoint;
    }

    public void setOssEndPoint(String ossEndPoint) {
        this.ossEndPoint = ossEndPoint;
    }

    public String getOssAccessId() {
        return this.ossAccessId;
    }

    public void setOssAccessId(String ossAccessId) {
        this.ossAccessId = ossAccessId;
    }

    public String getOssAccessKey() {
        return this.ossAccessKey;
    }

    public void setOssAccessKey(String ossAccessKey) {
        this.ossAccessKey = ossAccessKey;
    }

    public String getOssBucketName() {
        return this.ossBucketName;
    }

    public void setOssBucketName(String ossBucketName) {
        this.ossBucketName = ossBucketName;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public FileUploadResp uploadFile(String localFilePath, String extraPath, FileTypeEnum fileType) {
        File file = new File(localFilePath);
        return this.uploadFile(file, extraPath, fileType);
    }

    public String uploadImg(String suffix, InputStream content) {
        String fileName = DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss") + StringUtil.getRandomString((int)6, (String)"0123456789");
        return this.uploadImg(fileName, suffix, content);
    }

    public String uploadImg(String fileName, String suffix, InputStream content) {
        String key = "image/" + fileName + "." + suffix;
        ObjectMetadata meta = new ObjectMetadata();
        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }
        this.getOssClient().putObject(this.ossBucketName, key, content);
        return key;
    }

    public String uploadFile(String subdirectory, String fileName, String suffix, InputStream content) {
        String key = KEY_FILE + (EmptyUtil.isNotEmpty((String)subdirectory) ? subdirectory + File.separator : "") + fileName + "." + suffix;
        ObjectMetadata meta = new ObjectMetadata();
        MimeType mimeType = MimeType.findByName(suffix);
        if (mimeType != null) {
            meta.setContentType(mimeType.getContentType());
        }
        this.getOssClient().putObject(this.ossBucketName, key, content);
        return key;
    }

    public FileUploadResp uploadFile(File file, String extraPath, FileTypeEnum fileType) {
        FileUploadResp info = null;
        try {
            info = this.uploadFile((InputStream)new FileInputStream(file), extraPath, fileType);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25: {}", (Throwable)e);
        }
        return info;
    }

    public FileUploadResp uploadFile(InputStream inputStream, String extraPath, FileTypeEnum fileType) {
        FileUploadResp info = null;
        try {
            info = this.uploadFile(inputStream, extraPath, fileType, "");
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
        return info;
    }

    public FileUploadResp uploadFile(InputStream inputStream, String extraPath, String fileType) {
        return this.uploadFile(inputStream, extraPath, fileType, "");
    }

    public FileUploadResp uploadFile(File file, String extraPath, FileTypeEnum fileType, String fileName) {
        FileUploadResp info = null;
        try {
            info = this.uploadFile((InputStream)new FileInputStream(file), extraPath, fileType, fileName);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
        return info;
    }

    public FileUploadResp uploadFile(InputStream inputStream, String extraPath, FileTypeEnum fileType, String fileName) {
        FileUploadResp info = null;
        try {
            if (StringUtils.isBlank((String)fileName)) {
                fileName = UUID.randomUUID().toString().replace("-", "");
            }
            String key = BASE_PATH + this.buildExtraPath(extraPath) + fileName + "." + fileType.getName();
            this.getOssClient().putObject(this.ossBucketName, key, inputStream);
            info = new FileUploadResp(inputStream, this.baseUrl + key);
        }
        catch (Exception e) {
            this.logger.error("\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
        return info;
    }

    public FileUploadResp uploadFile(InputStream inputStream, String extraPath, String fileType, String fileName) {
        FileTypeEnum fileTypeEnum = FileTypeEnum.getEnumByName((String)fileType);
        if (fileTypeEnum == null) {
            throw new RuntimeException("\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301");
        }
        return this.uploadFile(inputStream, extraPath, fileTypeEnum, fileName);
    }

    public List<FileUploadResp> listFiles(String extraPath) {
        LinkedList<FileUploadResp> list = null;
        try {
            ObjectListing listing = this.getOssClient().listObjects(this.ossBucketName, BASE_PATH + this.buildExtraPath(extraPath));
            list = new LinkedList<FileUploadResp>();
            for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                list.add(this.getFile(this.baseUrl + objectSummary.getKey()));
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6587\u4ef6\u5217\u8868\u5f02\u5e38: {}", (Throwable)e);
        }
        return list;
    }

    public FileUploadResp getFile(String fileUrl) {
        FileUploadResp info = null;
        try {
            OSSObject ossObject = this.getOssClient().getObject(this.ossBucketName, this.getKey(fileUrl));
            info = new FileUploadResp(ossObject.getObjectContent(), fileUrl);
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
        return info;
    }

    public void deleteFile(String fileUrl) {
        try {
            String key = this.getKey(fileUrl);
            this.getOssClient().deleteObject(this.ossBucketName, key);
        }
        catch (Exception e) {
            this.logger.error("\u5220\u9664\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38: {}", (Throwable)e);
        }
    }
}

