/**
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeast.kit.alitool;

/**
 * @author Royan
 * @version $Id: MimeTypeConvertor.java, v 0.1 2015-08-14 下午2:27
 */
public enum MimeType {
    JPG("jpg", "image/jpeg"), JPEG("jpeg", "image/jpeg"), BMP("bmp", "image/bmp"), PNG("png",
                                                                                       "image/png"), GIF(
                                                                                                         "gif",
                                                                                                         "image/gif"), TIF(
                                                                                                                           "tif",
                                                                                                                           "image/tiff"), TIFF(
                                                                                                                                               "tiff",
                                                                                                                                               "image/tiff"),PDF("pdf","application/pdf");
    private String name;

    private String contentType;

    MimeType(String name, String contentType) {
        this.name = name;
        this.contentType = contentType;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContentType() {
        return contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public static MimeType findByName(String name) {
        for (MimeType mimeType : values()) {
            if (mimeType.name.equalsIgnoreCase(name)) {
                return mimeType;
            }
        }
        return null;
    }

    public static MimeType findByContentType(String contentType) {
        for (MimeType mimeType : values()) {
            if (mimeType.contentType.equalsIgnoreCase(contentType)) {
                return mimeType;
            }
        }
        return null;
    }
}