/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.aop;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.kit.actuator.anno.BeastMetrics;
import com.thebeastshop.kit.actuator.anno.MetricsType;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class MetricsAspect {
    private final String COUNT_KEY = "bm_count";
    private final String COUNT_E_KEY = "bm_count_e";
    private final String TIME_KEY = "bm_time";
    @Resource
    private MeterRegistry registry;

    @Pointcut(value="@within(com.thebeastshop.kit.actuator.anno.BeastMetrics)")
    public void cut1() {
    }

    @Pointcut(value="@annotation(com.thebeastshop.kit.actuator.anno.BeastMetrics)")
    public void cut2() {
    }

    @Around(value="cut1()")
    public Object around1(ProceedingJoinPoint jp) throws Throwable {
        Class<?> clazz = jp.getTarget().getClass();
        MethodSignature signature = (MethodSignature)jp.getSignature();
        Method method = signature.getMethod();
        BeastMetrics beastMetrics = clazz.getAnnotation(BeastMetrics.class);
        String description = beastMetrics.description();
        MetricsType metricsType = beastMetrics.metricsType();
        String methodTag = clazz.getSimpleName() + "." + method.getName();
        try {
            switch (metricsType) {
                case INVOKE_COUNT: {
                    Object object = jp.proceed();
                    Counter.builder((String)"bm_count").tag("method", methodTag).description(description).register(this.registry).increment();
                    return object;
                }
                case INVOKE_TIME: {
                    Timer timer = Timer.builder((String)"bm_time").tag("method", methodTag).description(description).register(this.registry);
                    return timer.recordCallable(() -> {
                        try {
                            return jp.proceed();
                        }
                        catch (Throwable e) {
                            throw new Exception(e);
                        }
                    });
                }
            }
            return jp.proceed();
        }
        catch (Throwable t) {
            Counter.builder((String)"bm_count_e").tag("method", methodTag).tag("message", t.getMessage()).tag("error_time", DateUtil.getNowFormat((String)"yyyy-MM-dd HH:mm:ss")).description(description).register(this.registry).increment();
            throw t;
        }
    }

    @Around(value="cut2()")
    public Object around2(ProceedingJoinPoint jp) throws Throwable {
        Class<?> clazz = jp.getTarget().getClass();
        Signature signature = jp.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        String methodTag = clazz.getSimpleName() + "#" + method.getName();
        BeastMetrics beastMetrics = method.getAnnotation(BeastMetrics.class);
        String description = beastMetrics.description();
        MetricsType metricsType = beastMetrics.metricsType();
        try {
            switch (metricsType) {
                case INVOKE_COUNT: {
                    Object object = jp.proceed();
                    Counter.builder((String)"bm_count").tag("method", methodTag).description(description).register(this.registry).increment();
                    return object;
                }
                case INVOKE_TIME: {
                    Timer timer = Timer.builder((String)"bm_time").tag("method", methodTag).description(description).register(this.registry);
                    return timer.recordCallable(() -> {
                        try {
                            return jp.proceed();
                        }
                        catch (Throwable e) {
                            throw new Exception(e);
                        }
                    });
                }
            }
            return jp.proceed();
        }
        catch (Throwable t) {
            Counter.builder((String)"bm_count_e").tag("method", methodTag).tag("message", t.getMessage()).description(description).register(this.registry).increment();
            throw t;
        }
    }
}

