package com.thebeastshop.kit.actuator.dubbo.prometheus.binder;

import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.bean.DubboInvokeHealthBinderBean;
import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.bean.DubboThreadPoolStatusBinderBean;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Random;

public class DubboThreadPoolStatusBinder implements MeterBinder {

    private DubboThreadPoolStatusBinderBean dubboThreadPoolStatusBinderBean;

    public DubboThreadPoolStatusBinder(DubboThreadPoolStatusBinderBean dubboThreadPoolStatusBinderBean){
        this.dubboThreadPoolStatusBinderBean = dubboThreadPoolStatusBinderBean;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Tags tags = Tags.of("dubbo", "threadPool");

        Gauge.builder("dubbo.threadPool.max", dubboThreadPoolStatusBinderBean, (bean) -> bean.getDubboThreadPoolStatus().getMaximumPoolSize())
                .tags(tags)
                .description("dubbo thread pool:max")
                .register(registry);

        Gauge.builder("dubbo.threadPool.core", dubboThreadPoolStatusBinderBean, (bean) -> bean.getDubboThreadPoolStatus().getCorePoolSize())
                .tags(tags)
                .description("dubbo thread pool:core")
                .register(registry);

        Gauge.builder("dubbo.threadPool.largest", dubboThreadPoolStatusBinderBean, (bean) -> bean.getDubboThreadPoolStatus().getLargestPoolSize())
                .tags(tags)
                .description("dubbo thread pool:largest")
                .register(registry);

        Gauge.builder("dubbo.threadPool.active", dubboThreadPoolStatusBinderBean, (bean) -> bean.getDubboThreadPoolStatus().getActiveCount())
                .tags(tags)
                .description("dubbo thread pool:active")
                .register(registry);

        Gauge.builder("dubbo.threadPool.task", dubboThreadPoolStatusBinderBean, (bean) -> bean.getDubboThreadPoolStatus().getTaskCount())
                .tags(tags)
                .description("dubbo thread pool:task")
                .register(registry);
    }
}
