package com.thebeastshop.kit.actuator.dubbo.prometheus.binder;

import com.google.common.util.concurrent.AtomicDouble;
import com.thebeastshop.kit.actuator.dubbo.health.biz.DubboHealthBizData;
import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.bean.DubboInvokeAlertCounterBinderBean;
import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.bean.DubboInvokeHealthBinderBean;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;

import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;

public class DubboInvokeAlertCounterBinder implements MeterBinder {

    private final static int DUBBO_LONG_TASK_SECONDS_3_THRESHOLD = 3;

    private final static int DUBBO_LONG_TASK_SECONDS_5_THRESHOLD = 5;

    private final static int DUBBO_LONG_TASK_SECONDS_10_THRESHOLD = 10;

    private DubboInvokeAlertCounterBinderBean dubboInvokeAlertCounterBinderBean;

    public DubboInvokeAlertCounterBinder(DubboInvokeAlertCounterBinderBean dubboInvokeAlertCounterBinderBean){
        this.dubboInvokeAlertCounterBinderBean = dubboInvokeAlertCounterBinderBean;
    }

    @Override
    public void bindTo(MeterRegistry registry) {
        Gauge.builder("dubbo_alert_invoke_3", dubboInvokeAlertCounterBinderBean, bean -> bean.getCount(DUBBO_LONG_TASK_SECONDS_3_THRESHOLD))
                .register(registry);

        Gauge.builder("dubbo_alert_invoke_5", dubboInvokeAlertCounterBinderBean, bean -> bean.getCount(DUBBO_LONG_TASK_SECONDS_5_THRESHOLD))
                .register(registry);

        Gauge.builder("dubbo_alert_invoke_10", dubboInvokeAlertCounterBinderBean, bean -> bean.getCount(DUBBO_LONG_TASK_SECONDS_10_THRESHOLD))
                .register(registry);
    }
}
