package com.thebeastshop.kit.actuator.config;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.core.env.Environment;

public class ActuatorPortInit implements InitializingBean {

    private ManagementServerProperties managementServerProperties;

    public static int actuatorPort;

    @Autowired
    private Environment environment;

    public ActuatorPortInit(ManagementServerProperties managementServerProperties) {
        this.managementServerProperties = managementServerProperties;
    }



    @Override
    public void afterPropertiesSet() {
        int actuatorPort;
        int port = environment.getProperty("server.port",Integer.class,-1);
        if (port == -1) {
            throw new RuntimeException("[beast-kit-actuator] please config the server.port first");
        } else {
            actuatorPort = 50000 + port;
        }

        ActuatorPortInit.actuatorPort = actuatorPort;
        this.managementServerProperties.setPort(actuatorPort);
    }
}
