/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.dubbo.health.biz;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.google.common.collect.Sets;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Set;

public class DubboHealthBizData {
    public static Set<LongTaskTimer> taskTimerSet = Sets.newConcurrentHashSet();
    private static MeterRegistry registry;

    public static void setRegistry(MeterRegistry registry) {
        DubboHealthBizData.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result timer(Invoker<?> invoker, Invocation invocation) {
        if (registry == null) {
            return invoker.invoke(invocation);
        }
        Result[] result = new Result[1];
        String methodName = invocation.getInvoker().getInterface().getName() + "." + invocation.getMethodName();
        Counter counter = registry.counter("dubbo_invoke", new String[]{"method", methodName});
        counter.increment();
        LongTaskTimer longTaskTimer = LongTaskTimer.builder((String)"dubbo_long_invoke").tag("method", methodName).register(registry);
        taskTimerSet.add(longTaskTimer);
        try {
            longTaskTimer.record(() -> {
                result[0] = invoker.invoke(invocation);
                return result[0];
            });
        }
        finally {
            taskTimerSet.remove(longTaskTimer);
        }
        return result[0];
    }
}

