/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.dubbo.prometheus.binder;

import com.thebeastshop.kit.actuator.dubbo.health.biz.DubboHealthBizData;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.util.concurrent.TimeUnit;

public class DubboLongTimerBinder
implements MeterBinder {
    private static final int DUBBO_LONG_TASK_SECONDS_3_THRESHOLD = 3;
    private static final int DUBBO_LONG_TASK_SECONDS_5_THRESHOLD = 5;
    private static final int DUBBO_LONG_TASK_SECONDS_10_THRESHOLD = 10;

    public void bindTo(MeterRegistry registry) {
        TimerCounter counter = new TimerCounter();
        Gauge.builder((String)"dubbo_alert_invoke_5", (Object)counter, TimerCounter::getCount).register(registry);
    }

    public static class TimerCounter {
        public double getCount() {
            double count = 0.0;
            for (LongTaskTimer longTaskTimer : DubboHealthBizData.taskTimerSet) {
                if (!(longTaskTimer.duration(TimeUnit.SECONDS) > 5.0)) continue;
                count += 1.0;
            }
            return count;
        }
    }
}

