/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.dubbo.autoconfigure;

import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.DubboInvokeHealthBinder;
import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.DubboLongTimerBinder;
import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.DubboThreadPoolStatusBinder;
import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.bean.DubboInvokeHealthBinderBean;
import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.bean.DubboThreadPoolStatusBinderBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnClass(name={"org.springframework.boot.actuate.health.Health"})
@ConditionalOnProperty(name={"management.health.dubbo.enabled"}, matchIfMissing=true, havingValue="true")
@PropertySource(name="Dubbo Endpoints Default Properties", value={"classpath:/META-INF/dubbo-endpoints-default.properties"})
public class DubboHealthBinderAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public DubboInvokeHealthBinderBean dubboInvokeHealthBinderBean() {
        return new DubboInvokeHealthBinderBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public DubboInvokeHealthBinder dubboInvokeHealthBinder(DubboInvokeHealthBinderBean dubboInvokeHealthBinderBean) {
        return new DubboInvokeHealthBinder(dubboInvokeHealthBinderBean);
    }

    @Bean
    @ConditionalOnMissingBean
    public DubboThreadPoolStatusBinderBean dubboThreadPoolStatusBinderBean() {
        return new DubboThreadPoolStatusBinderBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public DubboThreadPoolStatusBinder dubboThreadPoolStatusBinder(DubboThreadPoolStatusBinderBean dubboThreadPoolStatusBinderBean) {
        return new DubboThreadPoolStatusBinder(dubboThreadPoolStatusBinderBean);
    }

    @Bean
    @ConditionalOnMissingBean
    public DubboLongTimerBinder dubboLongTimerBinder() {
        return new DubboLongTimerBinder();
    }
}

