/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.dubbo.prometheus.binder.bean;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.status.Status;
import com.alibaba.dubbo.common.store.DataStore;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;

public class DubboThreadPoolStatusBinderBean {
    public DubboThreadPoolStatusVO getDubboThreadPoolStatus() {
        DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
        Map executors = dataStore.get(Constants.EXECUTOR_SERVICE_COMPONENT_KEY);
        StringBuilder msg = new StringBuilder();
        Status.Level level = Status.Level.OK;
        DubboThreadPoolStatusVO dubboThreadPoolStatusVO = null;
        for (Map.Entry entry : executors.entrySet()) {
            String port = (String)entry.getKey();
            ExecutorService executor = (ExecutorService)entry.getValue();
            if (executor == null || !(executor instanceof ThreadPoolExecutor)) continue;
            ThreadPoolExecutor tp = (ThreadPoolExecutor)executor;
            boolean ok = tp.getActiveCount() < tp.getMaximumPoolSize() - 1;
            Status.Level lvl = Status.Level.OK;
            if (!ok) {
                level = Status.Level.WARN;
                lvl = Status.Level.WARN;
            }
            if (msg.length() > 0) {
                msg.append(";");
            }
            msg.append("Pool status:" + lvl + ", max:" + tp.getMaximumPoolSize() + ", core:" + tp.getCorePoolSize() + ", largest:" + tp.getLargestPoolSize() + ", active:" + tp.getActiveCount() + ", task:" + tp.getTaskCount() + ", service port: " + port);
            dubboThreadPoolStatusVO = new DubboThreadPoolStatusVO();
            dubboThreadPoolStatusVO.setMaximumPoolSize(tp.getMaximumPoolSize());
            dubboThreadPoolStatusVO.setCorePoolSize(tp.getCorePoolSize());
            dubboThreadPoolStatusVO.setLargestPoolSize(tp.getLargestPoolSize());
            dubboThreadPoolStatusVO.setActiveCount(tp.getActiveCount());
            dubboThreadPoolStatusVO.setTaskCount(tp.getTaskCount());
        }
        return dubboThreadPoolStatusVO;
    }

    public class DubboThreadPoolStatusVO {
        private int maximumPoolSize;
        private int corePoolSize;
        private int largestPoolSize;
        private int activeCount;
        private long taskCount;

        public int getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public void setMaximumPoolSize(int maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public int getLargestPoolSize() {
            return this.largestPoolSize;
        }

        public void setLargestPoolSize(int largestPoolSize) {
            this.largestPoolSize = largestPoolSize;
        }

        public int getActiveCount() {
            return this.activeCount;
        }

        public void setActiveCount(int activeCount) {
            this.activeCount = activeCount;
        }

        public long getTaskCount() {
            return this.taskCount;
        }

        public void setTaskCount(long taskCount) {
            this.taskCount = taskCount;
        }
    }
}

