/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.config;

import com.google.common.collect.Lists;
import com.thebeastshop.kit.actuator.config.ActuatorPortInit;
import java.net.InetAddress;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.consul.discovery.ConsulDiscoveryProperties;
import org.springframework.core.env.Environment;

public class ServiceDiscoveryInit
implements InitializingBean {
    private ConsulDiscoveryProperties consulDiscoveryProperties;
    @Autowired
    private Environment environment;

    public ServiceDiscoveryInit(ConsulDiscoveryProperties consulDiscoveryProperties) {
        this.consulDiscoveryProperties = consulDiscoveryProperties;
    }

    public void afterPropertiesSet() throws Exception {
        int port = (Integer)this.environment.getProperty("server.port", Integer.class, (Object)-1);
        if (port == -1) {
            throw new RuntimeException("[beast-kit-actuator] please config the server.port first");
        }
        String appId = this.environment.getProperty("app.id", "");
        InetAddress inetAddress = InetAddress.getLocalHost();
        String instanceId = appId + "-" + inetAddress + "-" + StringUtils.trim((String)(port + ""));
        instanceId = instanceId.replaceAll("\\.", "-");
        this.consulDiscoveryProperties.setInstanceId(instanceId);
        String actuatorPort = ActuatorPortInit.actuatorPort + "";
        this.consulDiscoveryProperties.setHealthCheckUrl("http://" + inetAddress + ":" + actuatorPort);
        this.consulDiscoveryProperties.setTags((List)Lists.newArrayList());
    }
}

