package com.thebeastshop.kit.actuator.dubbo.health.biz.filter;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.*;
import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerService;
import com.thebeastshop.kit.actuator.dubbo.health.biz.DubboHealthBizData;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.concurrent.atomic.AtomicReference;

@Activate(group = {Constants.PROVIDER},order = -10000)
public class DubboHealthBizFilter implements Filter {

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        if (invoker.getInterface() == DubboCheckerService.class) {
            return invoker.invoke(invocation);
        }
        Result result = DubboHealthBizData.timer(invoker, invocation);
        return result;
    }


}
