/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.thebeastshop.kit.actuator.dubbo.autoconfigure;

import com.thebeastshop.kit.actuator.dubbo.health.DubboHealthIndicator;
import com.thebeastshop.kit.actuator.dubbo.health.DubboHealthIndicatorProperties;
import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.DubboInvokeHealthBinder;
import com.thebeastshop.kit.actuator.dubbo.prometheus.binder.bean.DubboInvokeHealthBinderBean;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Dubbo {@link DubboHealthIndicator} Auto Configuration
 *
 * @see HealthIndicator
 * @since 2.7.0
 */
@Configuration
@ConditionalOnClass(name = {
        "org.springframework.boot.actuate.health.Health"
})
@ConditionalOnProperty(name = "management.health.dubbo.enabled", matchIfMissing = true, havingValue = "true")
@EnableConfigurationProperties(DubboHealthIndicatorProperties.class)
public class DubboHealthBinderAutoConfiguration {

    /*@Bean
    @ConditionalOnMissingBean
    public DubboHealthIndicator dubboHealthIndicator() {
        return new DubboHealthIndicator();
    }*/

    @Bean
    @ConditionalOnMissingBean
    public DubboInvokeHealthBinderBean dubboInvokeHealthBinderBean() {
        return new DubboInvokeHealthBinderBean();
    }

    @Bean
    @ConditionalOnMissingBean
    public DubboInvokeHealthBinder dubboInvokeHealthBinder() {
        return new DubboInvokeHealthBinder();
    }

    /*@Bean
    @ConditionalOnMissingBean
    public DubboBizInvokeHealthIndicator dubboBizInvokeHealthIndicator() {
        return new DubboBizInvokeHealthIndicator();
    }*/
}
