/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.dubbo.health.biz;

import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DubboHealthBizData {
    public static final int HEALTH_TIMEOUT_MILLISECONDS = 5000;
    public static final double TIMEOUT_COUNT_THRESHOLD = 0.6;
    public static Date clearTime = new Date();
    private static AtomicInteger timeAreaTotalInvokeCount = new AtomicInteger(0);
    private static AtomicInteger timeAreaTimeoutInvokeCount = new AtomicInteger(0);
    private static MeterRegistry registry;

    public static void setRegistry(MeterRegistry registry) {
        DubboHealthBizData.registry = registry;
    }

    public static Result timer(Invoker<?> invoker, Invocation invocation) {
        if (registry == null) {
            return invoker.invoke(invocation);
        }
        AtomicReference result = new AtomicReference();
        String methodName = invocation.getInvoker().getInterface().getName() + "." + invocation.getMethodName();
        Counter counter = registry.counter("dubbo_invoke", new String[]{"method", methodName});
        counter.increment();
        LongTaskTimer longTaskTimer = LongTaskTimer.builder((String)"dubbo_long_invoke").tag("method", methodName).register(registry);
        Timer timer = Timer.builder((String)"dubbo_invoke_time").tag("method", methodName).register(registry);
        longTaskTimer.duration(5000L, TimeUnit.MILLISECONDS);
        longTaskTimer.record(() -> timer.record(() -> result.set(invoker.invoke(invocation))));
        return (Result)result.get();
    }

    public static void addOneTotalCount() {
        timeAreaTotalInvokeCount.incrementAndGet();
    }

    public static void addOneTimeoutCount() {
        timeAreaTimeoutInvokeCount.incrementAndGet();
    }

    public static void clear() {
        timeAreaTimeoutInvokeCount.set(0);
        timeAreaTotalInvokeCount.set(0);
        clearTime = new Date();
    }

    public static int getTimeAreaTotalInvokeCount() {
        return timeAreaTotalInvokeCount.intValue();
    }

    public static int getTimeAreaTimeoutInvokeCount() {
        return timeAreaTimeoutInvokeCount.intValue();
    }

    public static double getTimeoutCountRate() {
        if (timeAreaTotalInvokeCount.intValue() == 0) {
            return 0.0;
        }
        return new BigDecimal(timeAreaTimeoutInvokeCount.intValue()).divide(new BigDecimal(timeAreaTotalInvokeCount.intValue()), 2, RoundingMode.HALF_UP).doubleValue();
    }

    public static long IntervalSecondsOfClearTimeAndNow() {
        Date now = new Date();
        return (now.getTime() - clearTime.getTime()) / 1000L;
    }
}

