/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.dubbo.health.biz;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

public class DubboHealthBizData {
    public static final int HEALTH_TIMEOUT_MILLISECONDS = 5000;
    public static final double TIMEOUT_COUNT_THRESHOLD = 0.6;
    public static Date clearTime = new Date();
    private static AtomicInteger timeAreaTotalInvokeCount = new AtomicInteger(0);
    private static AtomicInteger timeAreaTimeoutInvokeCount = new AtomicInteger(0);

    public static void addOneTotalCount() {
        timeAreaTotalInvokeCount.incrementAndGet();
    }

    public static void addOneTimeoutCount() {
        timeAreaTimeoutInvokeCount.incrementAndGet();
    }

    public static void clear() {
        timeAreaTimeoutInvokeCount.set(0);
        timeAreaTotalInvokeCount.set(0);
        clearTime = new Date();
    }

    public static int getTimeAreaTotalInvokeCount() {
        return timeAreaTotalInvokeCount.intValue();
    }

    public static int getTimeAreaTimeoutInvokeCount() {
        return timeAreaTimeoutInvokeCount.intValue();
    }

    public static double getTimeoutCountRate() {
        if (timeAreaTotalInvokeCount.intValue() == 0) {
            return 0.0;
        }
        return new BigDecimal(timeAreaTimeoutInvokeCount.intValue()).divide(new BigDecimal(timeAreaTotalInvokeCount.intValue()), 2, RoundingMode.HALF_UP).doubleValue();
    }

    public static long IntervalSecondsOfClearTimeAndNow() {
        Date now = new Date();
        return (now.getTime() - clearTime.getTime()) / 1000L;
    }
}

