/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.actuator.dubbo.health;

import com.thebeastshop.kit.actuator.dubbo.checker.DubboCheckerService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.stereotype.Component;

@Component
public class DubboInvokeHealthIndicator
extends AbstractHealthIndicator {
    private Logger log = LoggerFactory.getLogger(DubboInvokeHealthIndicator.class);
    private static final String OK = "ok";
    @Resource(name="dubboCheckerService")
    private DubboCheckerService dubboCheckerConsumerService;

    protected void doHealthCheck(Health.Builder builder) {
        try {
            String result = this.dubboCheckerConsumerService.check();
            this.log.debug("[beast-kit-actuator] dubbo check: {}", (Object)result);
            if (result.equals(OK)) {
                builder.up();
            } else {
                builder.down();
            }
        }
        catch (Throwable t) {
            this.log.error("[beast-kit-actuator] \u8c03\u7528Dubbo\u68c0\u67e5\u63a5\u53e3\u5931\u8d25\uff0c\u670d\u52a1\u53ef\u80fd\u4e0d\u53ef\u7528! \u7531\u4e8e: \n" + t.getMessage(), t);
            builder.down();
        }
    }
}

