/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.jd;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
public class WebMvcConfig {
    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.OAS_30).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"com.thebeastshop.jd.service.impl")).paths(PathSelectors.any()).build().securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts());
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("\u4eac\u4e1c\u9f0e\u5185\u63a5\u53e3").description("").termsOfServiceUrl("http://localhost:8080/swagger-ui.html").contact(new Contact("\u90ed\u950b", "", "feng.guo@thebeastshop.com")).version("1.0").build();
    }

    private List<SecurityScheme> security() {
        return Lists.newArrayList((Object[])new SecurityScheme[]{new ApiKey("appKey", "appKey", "header")});
    }

    private List<SecurityContext> securityContexts() {
        ArrayList<SecurityContext> securityContextList = new ArrayList<SecurityContext>();
        ArrayList<SecurityReference> securityReferenceList = new ArrayList<SecurityReference>();
        securityReferenceList.add(new SecurityReference("token", this.scopes()));
        securityReferenceList.add(new SecurityReference("user_id", this.scopes()));
        securityReferenceList.add(new SecurityReference("appKey", this.scopes()));
        securityContextList.add(SecurityContext.builder().securityReferences(securityReferenceList).forPaths(PathSelectors.any()).build());
        return securityContextList;
    }

    private List<SecurityScheme> securitySchemes() {
        return this.security();
    }

    private AuthorizationScope[] scopes() {
        return new AuthorizationScope[]{new AuthorizationScope("global", "accessAnything")};
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={ObjectMapper.class})
    public ObjectMapper jacksonObjectMapper(Jackson2ObjectMapperBuilder builder) {
        ObjectMapper objectMapper = builder.createXmlMapper(false).build();
        objectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object o, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
                jsonGenerator.writeFieldName("");
            }
        });
        return objectMapper;
    }
}

