/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.jd;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.jd.dto.JdResponseResult;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class InterceptorConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(InterceptorConfiguration.class);
    private static final String[] AUTH_WHITELIST = new String[]{"/swagger-ui.html/**", "/swagger-ui/*", "/swagger-resources/**", "/v2/api-docs", "/v3/api-docs", "/webjars/**", "/error", "/null/**", "/doc.html"};

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new HttpInterceptor()).excludePathPatterns(AUTH_WHITELIST);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/springfox-swagger-ui/"}).resourceChain(false);
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/swagger-ui/").setViewName("forward:/swagger-ui/index.html");
    }

    private class HttpInterceptor
    implements HandlerInterceptor {
        private HttpInterceptor() {
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            String appKey = request.getHeader("appKey");
            if (appKey == null) {
                response.setContentType("application/json;charset=UTF-8");
                response.setStatus(401);
                PrintWriter responseWriter = response.getWriter();
                JdResponseResult responseResult = new JdResponseResult();
                responseResult.setCode("E401");
                responseResult.setResponseMsg("\u4ee4\u724c\u9519\u8bef\uff01");
                responseWriter.print(JSON.toJSONString((Object)responseResult));
                responseWriter.flush();
                responseWriter.close();
                return false;
            }
            String sign = request.getHeader("sign");
            return true;
        }
    }
}

