/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.exchange.enums;

import com.google.common.collect.Lists;
import com.thebeastshop.common.enums.CodeEnum;
import java.util.ArrayList;

public enum ExchgTypeEnum implements CodeEnum<Integer>
{
    SPU(1, "\u5546\u54c1"),
    COUPON(2, "\u4f18\u60e0\u52b5"),
    THIRD_COUPON(3, "\u7b2c\u4e09\u65b9\u5238"),
    GROUP_COUPON(4, "\u5957\u5238");

    private Integer code;
    private String name;

    private ExchgTypeEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(ExchgTypeEnum typeEnum) {
        if (typeEnum == null) {
            return false;
        }
        return this.code.equals(typeEnum.getCode());
    }

    public boolean equals(Integer code) {
        if (code == null) {
            return false;
        }
        return this.code.equals(code);
    }

    public static ExchgTypeEnum getEnumByCode(Integer code) {
        for (ExchgTypeEnum e : ExchgTypeEnum.values()) {
            if (e.code != code) continue;
            return e;
        }
        return null;
    }

    public static Boolean isCouponExchgType(ExchgTypeEnum exchgType) {
        ArrayList couponExchgType = Lists.newArrayList((Object[])new ExchgTypeEnum[]{COUPON, THIRD_COUPON, GROUP_COUPON});
        return couponExchgType.contains((Object)exchgType);
    }
}

