/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.exchange.enums;

import com.thebeastshop.common.utils.DateUtil;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public enum ExchgActivityStateEnum {
    ENDED("000", "\u5df2\u7ed3\u675f"),
    ON_VIEW("001", "\u5373\u5c06\u5f00\u59cb\u5c55\u793a\u4e2d"),
    UNDER_WAY("002", "\u8fdb\u884c\u4e2d"),
    NOT_STARTED("003", "\u672a\u5f00\u59cb"),
    INVALID("004", "\u65e0\u6548\u6d3b\u52a8");

    String code;
    String desc;

    private ExchgActivityStateEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Boolean isCurrentActivity(String code) {
        if (ON_VIEW.getCode().equalsIgnoreCase(code) || UNDER_WAY.getCode().equalsIgnoreCase(code)) {
            return true;
        }
        return false;
    }

    public static String getStateCodeByStartOrEndTime(Date startDate, Date endTime) {
        if (startDate == null || endTime == null) {
            return INVALID.getCode();
        }
        Long currentTime = new Date().getTime();
        if (startDate.getTime() > currentTime) {
            return NOT_STARTED.getCode();
        }
        if (startDate.getTime() < currentTime && endTime.getTime() > currentTime) {
            return UNDER_WAY.getCode();
        }
        if (endTime.getTime() < currentTime) {
            return ENDED.getCode();
        }
        return INVALID.getCode();
    }

    public static Boolean isShowOpenTime(Date startDate) {
        if (null == startDate) {
            return false;
        }
        Long currentTime = DateUtils.addDays((Date)new Date(), (int)30).getTime();
        if (currentTime > startDate.getTime()) {
            return true;
        }
        return false;
    }

    public static String getShowDateDesc(Date startDate, Date endTime) {
        StringBuffer dateDesc = new StringBuffer();
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        Integer currentYear = c.get(1);
        c.setTime(startDate);
        Integer startYear = c.get(1);
        if (currentYear.equals(startYear)) {
            String start = DateUtil.date2String((Date)startDate, (String)"MM.dd");
            String end = DateUtil.date2String((Date)endTime, (String)"MM.dd");
            dateDesc.append(start).append("-").append(end);
        } else {
            Integer startMonth = c.get(2) + 1;
            dateDesc.append("\u6b21\u5e74").append(startMonth).append("\u6708");
        }
        return dateDesc.toString();
    }
}

