/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.sdk.handler;

import cn.hutool.core.util.ObjectUtil;
import com.thebeastshop.bgel.Bgel;
import com.thebeastshop.bgel.BgelContext;
import com.thebeastshop.dts.enums.DTSChannel;
import com.thebeastshop.dts.enums.DTSRetryStatus;
import com.thebeastshop.dts.field.DTSFieldNameMode;
import com.thebeastshop.dts.record.DTSRecord;
import com.thebeastshop.dts.record.DTSRecordBuilder;
import com.thebeastshop.dts.record.DTSRecordField;
import com.thebeastshop.dts.sdk.DTSKafkaManager;
import com.thebeastshop.dts.sdk.handler.DTSBatchHandler;
import com.thebeastshop.dts.sdk.utils.DTSMetaObtainer;
import com.thebeastshop.dts.vo.RegisterItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.support.Acknowledgment;

public abstract class AbsDTSBatchHandler
implements DTSBatchHandler<List<DTSRecord>> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private List<RegisterItem> registerItems;
    private DTSFieldNameMode fieldNameMode;

    @Override
    public abstract void dataProcess(List<DTSRecord> var1) throws Throwable;

    @Override
    public void dataReceive(List<DTSRecord> recordList) {
        List<DTSRecord> filterDtsRecord = recordList.stream().filter(dtsRecord -> {
            RegisterItem registerItem = this.matchItem((DTSRecord)dtsRecord);
            if (ObjectUtil.isNull((Object)registerItem)) {
                return false;
            }
            if (StringUtils.isNotBlank((CharSequence)registerItem.getFilterEl())) {
                BgelContext context = new BgelContext();
                Map<String, Object> elDataMap = this.generatorElDataMap((DTSRecord)dtsRecord);
                context.setEnv(elDataMap);
                boolean flag = (Boolean)Bgel.eval((String)registerItem.getFilterEl(), (BgelContext)context);
                if (!flag) {
                    this.log.debug("[BEAST-DTS]\u6570\u636e\u88abEL\u8fc7\u6ee4:{}", dtsRecord);
                }
                return flag;
            }
            return true;
        }).collect(Collectors.toList());
        for (DTSRecord dtsRecord2 : recordList) {
            this.log.info("[BEAST-DTS]\u63a5\u53d7\u5230\u6570\u636e:{}", (Object)dtsRecord2);
        }
        try {
            this.dataProcess(filterDtsRecord);
        }
        catch (Throwable t) {
            String errorMsg = MessageFormat.format("[BEAST-DTS]\u8ba2\u9605\u5668{0}\u51fa\u73b0\u5f02\u5e38", this.getClass().getSimpleName());
            this.log.error(errorMsg, t);
            for (DTSRecord dtsRecord3 : recordList) {
                DTSRecordBuilder builder = DTSRecordBuilder.fromRecord((DTSRecord)dtsRecord3).setAppId(DTSMetaObtainer.APP_NAME).setChannel(DTSChannel.RECYCLE).setStatus(DTSRetryStatus.UNTREATED).setMessage(t.getMessage());
                DTSKafkaManager.loadRecycleSender().recycle((DTSRecord)builder.buildRetryRecord());
            }
        }
    }

    public void onMessage(List<ConsumerRecord<String, String>> data) {
        DTSBatchHandler.super.onMessage(data);
    }

    public void onMessage(List<ConsumerRecord<String, String>> data, Acknowledgment acknowledgment) {
        List<DTSRecord> dtsRecordList = data.stream().map(consumerRecord -> DTSRecordBuilder.fromJSON((DTSFieldNameMode)this.fieldNameMode, (String)((String)consumerRecord.value())).buildRecord()).collect(Collectors.toList());
        this.dataReceive(dtsRecordList);
        acknowledgment.acknowledge();
    }

    private Map<String, Object> generatorElDataMap(DTSRecord record) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry entry : record.getFields().entrySet()) {
            ret.put((String)entry.getKey(), ((DTSRecordField)entry.getValue()).getValue());
        }
        return ret;
    }

    private RegisterItem matchItem(DTSRecord record) {
        for (RegisterItem item : this.registerItems) {
            if (!item.getTableName().equals(record.getTableName())) continue;
            return item;
        }
        return null;
    }

    public List<RegisterItem> getRegisterItems() {
        return this.registerItems;
    }

    @Override
    public void setRegisterItems(List<RegisterItem> registerItems) {
        this.registerItems = registerItems;
    }

    @Override
    public void clearRegisterItems() {
        if (CollectionUtils.isNotEmpty(this.registerItems)) {
            this.registerItems.clear();
        }
    }

    @Override
    public void addRegisterItem(RegisterItem item) {
        if (this.registerItems == null) {
            this.registerItems = new ArrayList<RegisterItem>();
        }
        this.registerItems.add(item);
    }

    @Override
    public void setFieldNameMode(DTSFieldNameMode fieldNameMode) {
        this.fieldNameMode = fieldNameMode;
    }
}

