/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.sdk;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.dts.consumer.DTSConsumer;
import com.thebeastshop.dts.enums.DTSEnv;
import com.thebeastshop.dts.sdk.DTSHandlerManager;
import com.thebeastshop.dts.sdk.DTSKafkaManager;
import com.thebeastshop.dts.sdk.config.Config;
import com.thebeastshop.dts.sdk.exception.RegisterInfoNotFoundException;
import com.thebeastshop.dts.sdk.utils.DTSMetaObtainer;
import com.thebeastshop.dts.vo.HostDTO;
import com.thebeastshop.dts.vo.RegisterInfo;
import com.thebeastshop.dts.zk.DTSListener;
import com.thebeastshop.dts.zk.ZkDriver;
import java.net.InetAddress;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSConfigInitializer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_ZK_CONSUMER_NODE_COUNT = 50;
    private static DTSConfigInitializer dtsConfigInitializer;
    private ZkDriver zkDriver;
    private String zkAddress;
    private DTSEnv localDebugEnv;
    private volatile RegisterInfo registerInfo;
    private volatile DTSConsumer consumer;

    public static DTSConfigInitializer load(String zkAddress, DTSEnv localDebugEnv) {
        if (dtsConfigInitializer == null) {
            dtsConfigInitializer = new DTSConfigInitializer(zkAddress);
            dtsConfigInitializer.setLocalDebugEnv(localDebugEnv);
        }
        return dtsConfigInitializer;
    }

    public DTSConfigInitializer(String zkAddress) {
        this.zkAddress = zkAddress;
        this.zkDriver = ZkDriver.drive((String)zkAddress);
    }

    private String getZkConsumerPath() {
        String envName = this.consumer.getEnv().name();
        String env = Config.getEnv();
        if (this.localDebugEnv != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{env}) && "local".equals(env.toLowerCase())) {
            envName = this.localDebugEnv.name() + "-local-debug";
        }
        return "/dts/" + envName + "-consumers/" + this.consumer.getAppId() + "/" + this.consumer.getHost().getIp();
    }

    public DTSConsumer initConsumer() {
        if (this.consumer != null) {
            return this.consumer;
        }
        try {
            InetAddress ia = InetAddress.getLocalHost();
            String port = System.getProperty("server.port");
            if (StringUtils.isBlank((CharSequence)port)) {
                port = "-1";
            }
            HostDTO host = HostDTO.fromAddress((InetAddress)ia, (String)port);
            this.consumer = new DTSConsumer();
            this.consumer.setAppId(DTSMetaObtainer.APP_NAME);
            this.consumer.setEnv(DTSMetaObtainer.ENV);
            this.consumer.setHost(host);
            this.consumer.setSdkVersion("1.0.7");
        }
        catch (Throwable t) {
            this.log.error("[BEAST-DTS] \u83b7\u53d6\u672c\u5730\u670d\u52a1host\u4fe1\u606f\u5f02\u5e38", t);
        }
        if (this.consumer != null) {
            String nodePath = this.getZkConsumerPath();
            for (int i = 0; i < 50; ++i) {
                try {
                    this.zkDriver.createEphemeralNode(nodePath, JSON.toJSONString((Object)this.consumer));
                    this.log.info("[BEAST-DTS] \u521b\u5efadts\u6d88\u8d39\u8005\u6210\u529f\uff01");
                    break;
                }
                catch (Throwable th) {
                    try {
                        Thread.sleep(3000L);
                        this.log.warn("[BEAST-DTS] \u521b\u5efadts\u6d88\u8d39\u8005\u4e34\u65f6\u8282\u70b9\u5931\u8d25 [" + nodePath + "]!, \u7b2c" + (i + 1) + "\u6b21\u91cd\u8bd5");
                        if (i == 50) {
                            throw new RuntimeException("[BEAST-DTS] \u521b\u5efadts\u6d88\u8d39\u8005\u8282\u70b9[" + nodePath + "]\u5931\u8d25\uff01", th);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        return this.consumer;
    }

    private String getZkRegisterNodePath() {
        String envName = DTSMetaObtainer.ENV.name();
        String env = Config.getEnv();
        if (this.localDebugEnv != null && StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{env}) && "local".equals(env.toLowerCase())) {
            envName = this.localDebugEnv.name();
        }
        String nodePath = "/dts/" + envName + "/" + DTSMetaObtainer.APP_NAME;
        return nodePath;
    }

    public RegisterInfo initIfNeed() throws Exception {
        if (this.registerInfo != null) {
            return this.registerInfo;
        }
        String nodePath = this.getZkRegisterNodePath();
        this.log.info("[BEAST-DTS]\u4eceZK\u4e0a\u7684\u8282\u70b9{}\u4e0a\u83b7\u53d6\u4e0b\u53d1\u914d\u7f6e", (Object)nodePath);
        if (!this.zkDriver.checkExist(nodePath)) {
            throw new RegisterInfoNotFoundException("[BEAST-DTS]ZK\u4e0a\u7f3a\u5c11\u4e0b\u53d1\u8282\u70b9\u4fe1\u606f");
        }
        this.registerInfo = (RegisterInfo)this.zkDriver.getNodeData(nodePath, RegisterInfo.class);
        if (this.registerInfo == null) {
            throw new RegisterInfoNotFoundException("[BEAST-DTS]\u4eceZK\u52a0\u8f7d\u4e0d\u5230\u4e0b\u53d1\u4fe1\u606f");
        }
        this.log.info("[BEAST-DTS]\u6210\u529f\u4eceZK\u4e0a\u83b7\u53d6\u5ba2\u6237\u7aef\u914d\u7f6e:\n{}", (Object)JSON.toJSONString((Object)this.registerInfo));
        this.zkDriver.createListener(nodePath, (DTSListener)new DTSListener<RegisterInfo>(){

            public void dataChanged(RegisterInfo data) {
                DTSConfigInitializer.this.log.info("[BEAST-DTS]\u83b7\u53d6\u5230\u4e0b\u53d1\u914d\u7f6e:\n{}", (Object)JSON.toJSONString((Object)data));
                DTSHandlerManager.refreshHandlerConfig(data);
                DTSKafkaManager.load().initAllKafkaContainer(data);
                DTSConfigInitializer.this.registerInfo = data;
            }
        }, false);
        return this.registerInfo;
    }

    public String getZkAddress() {
        return this.zkAddress;
    }

    public void setZkAddress(String zkAddress) {
        this.zkAddress = zkAddress;
    }

    public DTSEnv getLocalDebugEnv() {
        return this.localDebugEnv;
    }

    public void setLocalDebugEnv(DTSEnv localDebugEnv) {
        this.localDebugEnv = localDebugEnv;
    }
}

