/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.sdk;

import com.thebeastshop.dts.kafka.KafkaDriver;
import com.thebeastshop.dts.sdk.DTSHandlerManager;
import com.thebeastshop.dts.sdk.DTSRecycleSender;
import com.thebeastshop.dts.sdk.annotation.DTSTable;
import com.thebeastshop.dts.sdk.exception.EmptyTopicException;
import com.thebeastshop.dts.sdk.handler.DTSHandler;
import com.thebeastshop.dts.sdk.handler.RetryDTSHandler;
import com.thebeastshop.dts.sdk.utils.DTSMetaObtainer;
import com.thebeastshop.dts.vo.RegisterInfo;
import com.thebeastshop.dts.vo.RegisterItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.MessageListener;

public class DTSKafkaManager {
    private static Logger log = LoggerFactory.getLogger(DTSKafkaManager.class);
    private static DTSKafkaManager dtsKafkaManager;
    private List<ConcurrentMessageListenerContainer> kafkaContainerList = new ArrayList<ConcurrentMessageListenerContainer>();
    private ConcurrentMessageListenerContainer retryKafkaContainer;
    private DTSRecycleSender recycleSender;

    public static DTSKafkaManager load() {
        if (dtsKafkaManager == null) {
            dtsKafkaManager = new DTSKafkaManager();
        }
        return dtsKafkaManager;
    }

    public static DTSRecycleSender loadRecycleSender() {
        return DTSKafkaManager.load().getRecycleSender();
    }

    public void initRecycleSenderIfNeed(RegisterInfo registerInfo) {
        if (this.recycleSender != null) {
            return;
        }
        this.recycleSender = new DTSRecycleSender(DTSMetaObtainer.getKafkaServers(registerInfo), registerInfo.getRecycleTopic());
        log.info("[BEAST-DTS]\u6210\u529f\u5efa\u7acb\u56de\u6536\u901a\u9053{}", (Object)registerInfo.getRecycleTopic());
    }

    public void initSubscriberContainer(RegisterInfo registerInfo, RegisterItem registerItem, DTSHandler dtsHandler) {
        DTSTable dtsTable = dtsHandler.getClass().getAnnotation(DTSTable.class);
        if (StringUtils.isBlank((CharSequence)registerItem.getTopic())) {
            String errorMsg = MessageFormat.format("[BEAST-DTS]\u6570\u636e\u8ba2\u9605\u5904\u7406\u5668[{0}]\u6ca1\u6709\u83b7\u53d6\u5230\u76f8\u5173TOPIC", dtsHandler.getClass().getSimpleName());
            throw new EmptyTopicException(errorMsg);
        }
        KafkaDriver kafkaDriver = KafkaDriver.drive((String)DTSMetaObtainer.getKafkaServers(registerInfo));
        ConcurrentMessageListenerContainer container = kafkaDriver.startConsumer(registerItem.getTopic(), DTSMetaObtainer.APP_NAME, (MessageListener)dtsHandler, dtsTable.concurrent());
        this.kafkaContainerList.add(container);
        log.info("[BEAST-DTS]\u6210\u529f\u4e3a{}\u5efa\u7acb\u6570\u636e\u8ba2\u9605\u901a\u9053{}", (Object)dtsHandler.getClass().getSimpleName(), (Object)registerItem.getTopic());
    }

    public void initRetryContainerIfNeed(RegisterInfo registerInfo) {
        if (this.retryKafkaContainer != null) {
            return;
        }
        this.retryKafkaContainer = KafkaDriver.drive((String)DTSMetaObtainer.getKafkaServers(registerInfo)).startConsumer(registerInfo.getRetryTopic(), DTSMetaObtainer.APP_NAME, (MessageListener)new RetryDTSHandler(), 1);
        log.info("[BEAST-DTS]\u6210\u529f\u5efa\u7acb\u91cd\u8bd5\u901a\u9053{}", (Object)registerInfo.getRetryTopic());
    }

    public void initAllKafkaContainer(RegisterInfo registerInfo) {
        for (ConcurrentMessageListenerContainer container : this.kafkaContainerList) {
            container.stop();
        }
        this.kafkaContainerList.clear();
        for (RegisterItem registerItem : registerInfo.getRegisterItems()) {
            DTSHandler handler = DTSHandlerManager.getHandler(registerItem.getTableName());
            if (handler == null) continue;
            this.initSubscriberContainer(registerInfo, registerItem, handler);
        }
    }

    public DTSRecycleSender getRecycleSender() {
        return this.recycleSender;
    }
}

