/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.sdk.scaner;

import com.google.common.collect.Lists;
import com.thebeastshop.dts.enums.DTSEnv;
import com.thebeastshop.dts.sdk.DTSConfigInitializer;
import com.thebeastshop.dts.sdk.DTSHandlerManager;
import com.thebeastshop.dts.sdk.DTSKafkaManager;
import com.thebeastshop.dts.sdk.annotation.DTSTable;
import com.thebeastshop.dts.sdk.annotation.DTSTableValueGetter;
import com.thebeastshop.dts.sdk.exception.HandlerRegisterException;
import com.thebeastshop.dts.sdk.handler.DTSHandler;
import com.thebeastshop.dts.vo.RegisterInfo;
import com.thebeastshop.dts.vo.RegisterItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.PriorityOrdered;

public class DTSHandlerScaner
implements BeanPostProcessor,
PriorityOrdered {
    private String zkAddress;
    private DTSEnv localDebugEnv = null;
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        try {
            if (DTSHandler.class.isAssignableFrom(bean.getClass())) {
                DTSHandler handler = (DTSHandler)bean;
                DTSTable dtsTable = handler.getClass().getAnnotation(DTSTable.class);
                if (dtsTable == null) {
                    String errorMsg = MessageFormat.format("[BEAST-DTS]\u6570\u636e\u8ba2\u9605\u5904\u7406\u5668{0}\u6ca1\u6709\u914d\u7f6e\u8ba2\u9605\u6807\u6ce8", handler.getClass().getSimpleName());
                    throw new HandlerRegisterException(errorMsg);
                }
                String tableName = dtsTable.value();
                if (StringUtils.isBlank((CharSequence)tableName)) {
                    String errorMsg = MessageFormat.format("[BEAST-DTS]\u6570\u636e\u8ba2\u9605\u5904\u7406\u5668{0}\u6ca1\u6709\u914d\u7f6e\u8ba2\u9605\u8868", handler.getClass().getSimpleName());
                    throw new HandlerRegisterException(errorMsg);
                }
                DTSHandlerManager.addHandler(handler);
                DTSConfigInitializer configInitializer = DTSConfigInitializer.load(this.zkAddress, this.localDebugEnv);
                configInitializer.initConsumer();
                RegisterInfo registerInfo = configInitializer.initIfNeed();
                DTSKafkaManager.load().initRetryContainerIfNeed(registerInfo);
                DTSKafkaManager.load().initRecycleSenderIfNeed(registerInfo);
                List<RegisterItem> itemList = this.getRegisterItem(registerInfo, dtsTable);
                if (CollectionUtils.isEmpty(itemList)) {
                    String errorMsg = MessageFormat.format("[BEAST-DTS]\u6570\u636e\u8ba2\u9605\u5904\u7406\u5668{0}\u914d\u7f6e\u7684\u8ba2\u9605\u6b63\u5219\u8868\u8fbe\u5f0f{1}\u65e0\u6548", handler.getClass().getSimpleName(), dtsTable.value());
                    throw new HandlerRegisterException(errorMsg);
                }
                handler.setRegisterItems(itemList);
                for (RegisterItem item : itemList) {
                    DTSKafkaManager.load().initSubscriberContainer(registerInfo, item, handler);
                    this.log.info("[BEAST-DTS]\u6570\u636e\u8ba2\u9605\u5904\u7406\u5668{}\u5df2\u6210\u529f\u88ab\u6ce8\u518c", (Object)handler.getClass().getSimpleName());
                }
            }
        }
        catch (Throwable t) {
            this.log.error(t.getMessage(), t);
            String errorMsg = MessageFormat.format("[BEAST-DTS]\u626b\u63cf\u521d\u59cb\u5316DTSHandler[{0}]\u51fa\u73b0\u5f02\u5e38", bean.getClass().getSimpleName());
            throw new BeanInitializationException(errorMsg, t);
        }
        return bean;
    }

    private List<RegisterItem> getRegisterItem(RegisterInfo registerInfo, DTSTable dtsTable) {
        ArrayList matchedRegisterItems = Lists.newArrayList();
        String dtsTableValue = DTSTableValueGetter.getValue(dtsTable);
        if (StringUtils.isBlank((CharSequence)dtsTableValue)) {
            return Lists.newArrayList();
        }
        String[] tableNames = dtsTableValue.split("[ \t\n\r]*,[ \t\n\r]*");
        for (RegisterItem item : registerInfo.getRegisterItems()) {
            for (String tableName : tableNames) {
                if (!Pattern.matches(tableName, item.getTableName())) continue;
                matchedRegisterItems.add(item);
            }
        }
        return matchedRegisterItems;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public String getZkAddress() {
        return this.zkAddress;
    }

    public void setZkAddress(String zkAddress) {
        this.zkAddress = zkAddress;
    }

    public DTSEnv getLocalDebugEnv() {
        return this.localDebugEnv;
    }

    public void setLocalDebugEnv(DTSEnv localDebugEnv) {
        this.localDebugEnv = localDebugEnv;
    }
}

