/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.sdk.handler;

import com.thebeastshop.bgel.Bgel;
import com.thebeastshop.bgel.BgelContext;
import com.thebeastshop.dts.enums.DTSChannel;
import com.thebeastshop.dts.enums.DTSRetryStatus;
import com.thebeastshop.dts.record.DTSRecord;
import com.thebeastshop.dts.record.DTSRecordBuilder;
import com.thebeastshop.dts.record.DTSRecordField;
import com.thebeastshop.dts.sdk.DTSKafkaManager;
import com.thebeastshop.dts.sdk.handler.DTSHandler;
import com.thebeastshop.dts.sdk.utils.DTSMetaObtainer;
import com.thebeastshop.dts.vo.RegisterItem;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbsDTSHandler
implements DTSHandler<DTSRecord> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private List<RegisterItem> registerItems;

    @Override
    public abstract void dataProcess(DTSRecord var1) throws Throwable;

    @Override
    public void dataRecieve(DTSRecord record) {
        RegisterItem registerItem = this.matchItem(record);
        if (StringUtils.isNotBlank((CharSequence)registerItem.getFilterEl())) {
            BgelContext context = new BgelContext();
            Map<String, Object> elDataMap = this.generatorElDataMap(record);
            context.setEnv(elDataMap);
            boolean flag = (Boolean)Bgel.eval((String)registerItem.getFilterEl(), (BgelContext)context);
            if (!flag) {
                this.log.debug("[BEAST-DTS]\u6570\u636e\u88abEL\u8fc7\u6ee4:{}", (Object)record.toString());
                return;
            }
        }
        this.log.info("[BEAST-DTS]\u63a5\u53d7\u5230\u6570\u636e:{}", (Object)record.toString());
        try {
            this.dataProcess(record);
        }
        catch (Throwable t) {
            String errorMsg = MessageFormat.format("[BEAST-DTS]\u8ba2\u9605\u5668{0}\u51fa\u73b0\u5f02\u5e38", this.getClass().getSimpleName());
            this.log.error(errorMsg, t);
            DTSRecordBuilder builder = DTSRecordBuilder.fromRecord((DTSRecord)record).setAppId(DTSMetaObtainer.APP_NAME).setChannel(DTSChannel.RECYCLE).setStatus(DTSRetryStatus.UNTREATED).setMessage(t.getMessage());
            DTSKafkaManager.loadRecycleSender().recycle((DTSRecord)builder.buildRetryRecord());
        }
    }

    public void onMessage(ConsumerRecord<String, String> data) {
        DTSRecord record = DTSRecordBuilder.fromJSON((String)((String)data.value())).buildRecord();
        this.dataRecieve(record);
    }

    private Map<String, Object> generatorElDataMap(DTSRecord record) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (Map.Entry entry : record.getFields().entrySet()) {
            ret.put((String)entry.getKey(), ((DTSRecordField)entry.getValue()).getValue());
        }
        return ret;
    }

    private RegisterItem matchItem(DTSRecord record) {
        for (RegisterItem item : this.registerItems) {
            if (!item.getTableName().equals(record.getTableName())) continue;
            return item;
        }
        return null;
    }

    public List<RegisterItem> getRegisterItems() {
        return this.registerItems;
    }

    @Override
    public void setRegisterItems(List<RegisterItem> registerItems) {
        this.registerItems = registerItems;
    }

    @Override
    public void clearRegisterItems() {
        if (CollectionUtils.isNotEmpty(this.registerItems)) {
            this.registerItems.clear();
        }
    }

    @Override
    public void addRegisterItem(RegisterItem item) {
        if (this.registerItems == null) {
            this.registerItems = new ArrayList<RegisterItem>();
        }
        this.registerItems.add(item);
    }
}

