/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.sdk.springboot;

import com.thebeastshop.dts.enums.DTSEnv;
import com.thebeastshop.dts.sdk.scaner.DTSHandlerScaner;
import com.thebeastshop.kit.prop.PropConstants;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"dts.zk.address"})
public class DTSAutoConfiguration {
    public static final String DTS_ZK_ADDRESS_KEY = "dts.zk.address";

    @Bean
    public DTSHandlerScaner dtsHandlerScaner() {
        String dtsZkAddress = PropConstants.getProperties((String)DTS_ZK_ADDRESS_KEY);
        if (StringUtils.isBlank((CharSequence)dtsZkAddress)) {
            return null;
        }
        DTSHandlerScaner dtsHandlerScaner = new DTSHandlerScaner();
        dtsHandlerScaner.setZkAddress(dtsZkAddress);
        String localDebugEnv = PropConstants.getProperties((String)"dts.localDebugEnv");
        if (StringUtils.isBlank((CharSequence)localDebugEnv)) {
            return dtsHandlerScaner;
        }
        DTSEnv env = DTSEnv.valueOf((String)localDebugEnv.toUpperCase());
        dtsHandlerScaner.setLocalDebugEnv(env);
        return dtsHandlerScaner;
    }
}

