/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.zk;

import com.alibaba.fastjson.JSON;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

public abstract class DTSChildrenListener<T>
implements PathChildrenCacheListener {
    public void childEvent(CuratorFramework curator, PathChildrenCacheEvent event) throws Exception {
        if (event.getData() == null) {
            return;
        }
        String str = new String(event.getData().getData());
        Object data = JSON.parseObject((String)str, this.getClazz());
        String path = event.getData().getPath();
        switch (event.getType()) {
            case CHILD_ADDED: {
                this.onChildAdded(data, path);
                break;
            }
            case CHILD_UPDATED: {
                this.onChildUpdated(data, path);
                break;
            }
            case CHILD_REMOVED: {
                this.onChildRemoved(data, path);
                break;
            }
        }
    }

    private Class<T> getClazz() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getActualTypeArguments()[0];
        }
        return (Class)type;
    }

    public abstract void onChildAdded(T var1, String var2);

    public abstract void onChildUpdated(T var1, String var2);

    public abstract void onChildRemoved(T var1, String var2);
}

