/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.record;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.thebeastshop.dts.enums.DTSFieldType;
import com.thebeastshop.dts.exception.DTSParseValueException;
import com.thebeastshop.dts.record.DTSRecordField;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSRecordFieldBuilder {
    private static Logger logger = LoggerFactory.getLogger(DTSRecordFieldBuilder.class);
    private String name;
    private Object value;
    private Object oldValue;
    private DTSFieldType type;

    public static Map<String, DTSRecordFieldBuilder> fromRecordFields(Map<String, DTSRecordField> fields) {
        HashMap<String, DTSRecordFieldBuilder> map = new HashMap<String, DTSRecordFieldBuilder>();
        for (Map.Entry<String, DTSRecordField> entry : fields.entrySet()) {
            map.put(entry.getKey(), DTSRecordFieldBuilder.fromRecordField(entry.getValue()));
        }
        return map;
    }

    public static DTSRecordFieldBuilder fromRecordField(DTSRecordField field) {
        return new DTSRecordFieldBuilder().setRecordField(field);
    }

    public DTSRecordFieldBuilder setRecordField(DTSRecordField field) {
        return new DTSRecordFieldBuilder().setName(field.getName()).setValue(field.getValue()).setType(field.getType());
    }

    public String getName() {
        return this.name;
    }

    public DTSRecordFieldBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    public DTSRecordFieldBuilder setValue(Object value) {
        this.value = value;
        return this;
    }

    public Object getOldValue() {
        return this.oldValue;
    }

    public void setOldValue(Object oldValue) {
        this.oldValue = oldValue;
    }

    public DTSRecordFieldBuilder setNewParseValue(DTSFieldType type, String value) {
        return this.setParseValue(type, value, false);
    }

    public DTSRecordFieldBuilder setOldParseValue(String value) {
        return this.setOldParseValue(this.type, value);
    }

    public DTSRecordFieldBuilder setOldParseValue(DTSFieldType type, String value) {
        return this.setParseValue(type, value, true);
    }

    private DTSRecordFieldBuilder setParseValue(DTSFieldType type, String value, boolean old) {
        this.type = type;
        try {
            if (old) {
                this.oldValue = this.parseFieldValue(type, value);
            } else {
                this.value = this.parseFieldValue(type, value);
            }
        }
        catch (Throwable th) {
            if (th instanceof DTSParseValueException) {
                logger.error(((DTSParseValueException)th).getMessageWithFieldName(this.name));
            }
            logger.error("[DTS ERROR]: " + th.getCause() + " --> type: " + type.name() + ", value: " + value);
        }
        return this;
    }

    public DTSFieldType getType() {
        return this.type;
    }

    public DTSRecordFieldBuilder setType(DTSFieldType type) {
        this.type = type;
        return this;
    }

    public DTSRecordField buildField() {
        DTSRecordField field = new DTSRecordField(this.name, this.value, this.oldValue, this.type);
        return field;
    }

    private Object parseFieldValue(DTSFieldType type, String value) {
        if (value == null) {
            return null;
        }
        try {
            switch (type) {
                case BIT: {
                    return Byte.valueOf(value);
                }
                case INT: {
                    return Integer.parseInt(value);
                }
                case LONG: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case DECIMAL: {
                    return new BigDecimal(value);
                }
                case STRING: {
                    return String.valueOf(value);
                }
                case DATE: {
                    return this.parseDate(value);
                }
                case JSON: {
                    JSON json = (JSON)JSON.parse((String)value);
                    return json;
                }
            }
        }
        catch (Throwable th) {
            throw new DTSParseValueException(type, value, th);
        }
        return null;
    }

    private Date parseDate(String str) {
        if (NumberUtil.isNumber((CharSequence)str)) {
            return new Date(Long.parseLong(str));
        }
        return DateUtil.parse((String)str, (String[])new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd", "yyyyMMdd", "yyyy/MM/dd HH:mm:ss", "yyyy\\MM\\dd HH:mm:ss"});
    }
}

