/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.record;

import com.alibaba.fastjson.JSONObject;
import com.thebeastshop.dts.enums.DTSChannel;
import com.thebeastshop.dts.enums.DTSEnv;
import com.thebeastshop.dts.enums.DTSFieldType;
import com.thebeastshop.dts.enums.DTSOptType;
import com.thebeastshop.dts.enums.DTSRetryStatus;
import com.thebeastshop.dts.field.DTSFieldNameMode;
import com.thebeastshop.dts.field.RawMode;
import com.thebeastshop.dts.record.DTSRecord;
import com.thebeastshop.dts.record.DTSRecordField;
import com.thebeastshop.dts.record.DTSRecordFieldBuilder;
import com.thebeastshop.dts.record.DTSRetryRecord;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DTSRecordBuilder {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private DTSEnv env;
    private String recordId;
    private String subscriberId;
    private String dbName;
    private String tableName;
    private String ruleUUID;
    private DTSOptType optType;
    private DTSChannel channel;
    private Map<String, DTSRecordField> fields;
    private String appId;
    private DTSRetryStatus status;
    private Integer retryCount = 0;
    private String message;
    private Date receiveTime;

    public static DTSRecordBuilder fromJSON(String jsonString) {
        return DTSRecordBuilder.fromJSON(RawMode.INSTANCE, jsonString);
    }

    public static DTSRecordBuilder fromJSON(DTSFieldNameMode fieldNameMode, String jsonString) {
        return new DTSRecordBuilder().parseJSON(fieldNameMode, jsonString);
    }

    public static DTSRecordBuilder fromRecord(DTSRecord record) {
        return new DTSRecordBuilder().setRecord(record);
    }

    public DTSRecordBuilder parseJSON(DTSFieldNameMode fieldNameMode, String jsonString) {
        JSONObject json = JSONObject.parseObject((String)jsonString);
        this.setSubscriberId(json.getString("subscriberId"));
        this.setDbName(json.getString("dbName"));
        this.setTableName(json.getString("tableName"));
        this.setRuleUUID(json.getString("ruleUUID"));
        this.setOptType((DTSOptType)((Object)json.getObject("optType", DTSOptType.class)));
        this.setChannel((DTSChannel)((Object)json.getObject("channel", DTSChannel.class)));
        this.setEnv(DTSEnv.valueOf(json.getString("env")));
        if (this.getChannel() != DTSChannel.SUBSCRIBE) {
            this.setRecordId(json.getString("retryId"));
            this.setAppId(json.getString("appId"));
            this.setStatus((DTSRetryStatus)((Object)json.getObject("status", DTSRetryStatus.class)));
            this.setRetryCount(json.getInteger("retryCount"));
            this.setMessage(json.getString("message"));
        }
        JSONObject fieldBuilders = json.getJSONObject("fields");
        HashMap<String, DTSRecordField> fields = new HashMap<String, DTSRecordField>();
        for (String key : fieldBuilders.keySet()) {
            JSONObject field = fieldBuilders.getJSONObject(key);
            DTSFieldType ftype = (DTSFieldType)((Object)field.getObject("type", DTSFieldType.class));
            String fieldName = field.getString("name");
            if (fieldNameMode != null) {
                fieldName = fieldNameMode.transferFieldName(this, fieldName);
            }
            DTSRecordFieldBuilder fieldBuilder = new DTSRecordFieldBuilder().setName(fieldName).setType(ftype).setNewParseValue(ftype, field.getString("value")).setOldParseValue(field.getString("oldValue"));
            fields.put(fieldName, fieldBuilder.buildField());
        }
        this.setFields(fields);
        return this;
    }

    public DTSRecordBuilder setRecord(DTSRecord record) {
        DTSRecordBuilder builder = new DTSRecordBuilder().setEnv(record.getEnv()).setSubscriberId(record.getSubscriberId()).setDbName(record.getDbName()).setTableName(record.getTableName()).setOptType(record.getOptType()).setChannel(record.getChannel()).setFields(record.getFields()).setRuleUUID(record.getRuleUUID());
        if (record instanceof DTSRetryRecord) {
            DTSRetryRecord retryRecord = (DTSRetryRecord)record;
            builder.setAppId(retryRecord.getAppId()).setStatus(retryRecord.getStatus()).setRetryCount(retryRecord.getRetryCount()).setMessage(retryRecord.getMessage());
        }
        return builder;
    }

    public DTSEnv getEnv() {
        return this.env;
    }

    public DTSRecordBuilder setEnv(DTSEnv env) {
        this.env = env;
        return this;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public DTSRecordBuilder setRecordId(String recordId) {
        this.recordId = recordId;
        return this;
    }

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public DTSRecordBuilder setSubscriberId(String subscriberId) {
        this.subscriberId = subscriberId;
        return this;
    }

    public String getDbName() {
        return this.dbName;
    }

    public DTSRecordBuilder setDbName(String dbName) {
        this.dbName = dbName;
        return this;
    }

    public String getTableName() {
        return this.tableName;
    }

    public DTSRecordBuilder setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public String getRuleUUID() {
        return this.ruleUUID;
    }

    public DTSRecordBuilder setRuleUUID(String ruleUUID) {
        this.ruleUUID = ruleUUID;
        return this;
    }

    public DTSOptType getOptType() {
        return this.optType;
    }

    public DTSRecordBuilder setOptType(DTSOptType optType) {
        this.optType = optType;
        return this;
    }

    public DTSChannel getChannel() {
        return this.channel;
    }

    public DTSRecordBuilder setChannel(DTSChannel channel) {
        this.channel = channel;
        return this;
    }

    public Map<String, DTSRecordField> getFields() {
        return this.fields;
    }

    public DTSRecordBuilder setFields(Map<String, DTSRecordField> fields) {
        this.fields = fields;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public DTSRecordBuilder setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public DTSRetryStatus getStatus() {
        return this.status;
    }

    public DTSRecordBuilder setStatus(DTSRetryStatus status) {
        this.status = status;
        return this;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public DTSRecordBuilder setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public DTSRecordBuilder setMessage(String message) {
        this.message = message;
        return this;
    }

    private void validateRecordParameters() {
        Validate.notNull((Object)((Object)this.env), (String)"\u73af\u5883\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.dbName, (String)"\u6570\u636e\u5e93\u540d\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.tableName, (String)"\u8868\u540d\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)this.ruleUUID, (String)"\u89c4\u5219UUID\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)this.optType), (String)"\u64cd\u4f5c\u7c7b\u578b\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)this.channel), (String)"\u6570\u636e\u53d1\u9001\u7ba1\u9053\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull(this.fields, (String)"\u6570\u636e\u5b57\u6bb5\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void validateRetryRecordParameters() {
        Validate.notBlank((CharSequence)this.appId, (String)"App ID\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)this.status), (String)"\u91cd\u8bd5\u72b6\u6001\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)this.retryCount, (String)"\u91cd\u8bd5\u6b21\u6570\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    public DTSRecord buildRecord() {
        switch (this.channel) {
            case SUBSCRIBE: {
                return this.buildSubscribeRecord();
            }
        }
        return this.buildRetryRecord();
    }

    public DTSRecord buildSubscribeRecord() {
        this.validateRecordParameters();
        DTSRecord record = new DTSRecord(this.env, this.dbName, this.subscriberId, this.tableName, this.ruleUUID, this.optType, this.channel, this.receiveTime);
        record.setFields(this.fields);
        return record;
    }

    public DTSRetryRecord buildRetryRecord() {
        this.validateRecordParameters();
        this.validateRetryRecordParameters();
        DTSRetryRecord retryRecord = new DTSRetryRecord(this.env, this.dbName, this.subscriberId, this.tableName, this.ruleUUID, this.optType, this.channel, this.receiveTime);
        retryRecord.setRetryId(this.recordId);
        retryRecord.setFields(this.fields);
        retryRecord.setAppId(this.appId);
        retryRecord.setRetryCount(this.retryCount);
        retryRecord.setStatus(this.status);
        retryRecord.setMessage(this.message);
        return retryRecord;
    }

    public DTSRecordBuilder setReceiveTime(Date receiveTime) {
        this.receiveTime = receiveTime;
        return this;
    }

    public Date getReceiveTime() {
        return this.receiveTime;
    }
}

