/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.kafka;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.CreateTopicsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.AbstractMessageListenerContainer;
import org.springframework.kafka.listener.AcknowledgingMessageListener;
import org.springframework.kafka.listener.BatchAcknowledgingMessageListener;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.config.ContainerProperties;

public class KafkaDriver {
    private static Map<String, KafkaDriver> kafkaDriverMap = new ConcurrentHashMap<String, KafkaDriver>();
    private String bootstrapServers;
    private KafkaTemplate kafkaTemplate;
    private AdminClient adminClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KafkaDriver drive(String bootstrapServers) {
        KafkaDriver kafkaDriver = kafkaDriverMap.get(bootstrapServers);
        if (kafkaDriver == null) {
            Map<String, KafkaDriver> map = kafkaDriverMap;
            synchronized (map) {
                if (kafkaDriver == null) {
                    kafkaDriver = new KafkaDriver(bootstrapServers);
                    kafkaDriverMap.put(bootstrapServers, kafkaDriver);
                }
            }
        }
        return kafkaDriver;
    }

    public KafkaDriver(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        Map<String, Object> kafkaTemplateProperties = this.initKafkaTemplateProperties(bootstrapServers);
        DefaultKafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory(kafkaTemplateProperties);
        this.kafkaTemplate = new KafkaTemplate((ProducerFactory)producerFactory, true);
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        this.adminClient = AdminClient.create((Properties)properties);
    }

    public ConcurrentMessageListenerContainer startConsumer(String topicName, String groupId, AcknowledgingMessageListener listener, int concurrency) {
        Map<String, Object> propertiesMap = this.initKafkaConsumerProperties(groupId);
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(propertiesMap);
        ContainerProperties containerProperties = new ContainerProperties(new String[]{topicName});
        containerProperties.setMessageListener((Object)listener);
        containerProperties.setAckMode(AbstractMessageListenerContainer.AckMode.MANUAL);
        ConcurrentMessageListenerContainer container = new ConcurrentMessageListenerContainer((ConsumerFactory)consumerFactory, containerProperties);
        container.setConcurrency(concurrency);
        container.start();
        return container;
    }

    public ConcurrentMessageListenerContainer startBatchConsumer(String topicName, String groupId, BatchAcknowledgingMessageListener listener, int concurrency) {
        Map<String, Object> propertiesMap = this.initKafkaConsumerProperties(groupId);
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(propertiesMap);
        ContainerProperties containerProperties = new ContainerProperties(new String[]{topicName});
        containerProperties.setMessageListener((Object)listener);
        containerProperties.setAckMode(AbstractMessageListenerContainer.AckMode.MANUAL);
        ConcurrentMessageListenerContainer container = new ConcurrentMessageListenerContainer((ConsumerFactory)consumerFactory, containerProperties);
        container.setConcurrency(concurrency);
        container.start();
        return container;
    }

    public void createTopic(String topicName, int numPartitions) throws Exception {
        NewTopic newTopic = new NewTopic(topicName, numPartitions, 1);
        CreateTopicsResult result = this.adminClient.createTopics((Collection)Lists.newArrayList((Object[])new NewTopic[]{newTopic}));
        KafkaFuture kafkaFuture = result.all();
        kafkaFuture.get();
    }

    public void removeTopic(String topicName) {
        this.adminClient.deleteTopics((Collection)Lists.newArrayList((Object[])new String[]{topicName}));
    }

    public void send(Object data, String topic) {
        this.kafkaTemplate.send(topic, null, (Object)JSON.toJSONString((Object)data));
    }

    public void send(Object key, Object data, String topic) {
        this.kafkaTemplate.send(topic, key, (Object)JSON.toJSONString((Object)data));
    }

    private Map<String, Object> initKafkaConsumerProperties(String groupId) {
        HashMap<String, Object> kafkaConsumerProperties = new HashMap<String, Object>();
        kafkaConsumerProperties.put("bootstrap.servers", this.bootstrapServers);
        kafkaConsumerProperties.put("group.id", groupId);
        kafkaConsumerProperties.put("enable.auto.commit", "false");
        kafkaConsumerProperties.put("session.timeout.ms", "60000");
        kafkaConsumerProperties.put("key.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        kafkaConsumerProperties.put("value.deserializer", "org.apache.kafka.common.serialization.StringDeserializer");
        kafkaConsumerProperties.put("max.poll.interval.ms", "1200000");
        return kafkaConsumerProperties;
    }

    private Map<String, Object> initKafkaTemplateProperties(String kafkaBootstrapServers) {
        HashMap<String, Object> kafkaTemplateProperties = new HashMap<String, Object>();
        kafkaTemplateProperties.put("bootstrap.servers", kafkaBootstrapServers);
        kafkaTemplateProperties.put("retries", 3);
        kafkaTemplateProperties.put("batch.size", 16384);
        kafkaTemplateProperties.put("linger.ms", 1);
        kafkaTemplateProperties.put("buffer.memory", 0x2000000);
        kafkaTemplateProperties.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        kafkaTemplateProperties.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        return kafkaTemplateProperties;
    }

    public AdminClient getAdminClient() {
        return this.adminClient;
    }

    public void setAdminClient(AdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public static void main(String[] args) throws IOException {
        try {
            KafkaDriver driver = KafkaDriver.drive("114.55.236.27:9092,114.55.236.27:9093,114.55.236.27:9094");
            NewTopic newTopic = new NewTopic("dm_8", 2, 1);
            CreateTopicsResult createResult = driver.getAdminClient().createTopics((Collection)Lists.newArrayList((Object[])new NewTopic[]{newTopic}));
            KafkaFuture kafkaFuture = createResult.all();
            kafkaFuture.get();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }
}

