/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.record;

import com.thebeastshop.dts.enums.DTSChannel;
import com.thebeastshop.dts.enums.DTSEnv;
import com.thebeastshop.dts.enums.DTSOptType;
import com.thebeastshop.dts.record.DTSRecordField;
import java.io.Serializable;
import java.util.Map;

public class DTSRecord
implements Serializable {
    private final DTSEnv env;
    private final String dbName;
    private final String subscriberId;
    private final String tableName;
    private final String ruleUUID;
    private final DTSOptType optType;
    private final DTSChannel channel;
    private Map<String, DTSRecordField> fields;

    DTSRecord(DTSEnv env, String dbName, String subscriberId, String tableName, String ruleUUID, DTSOptType optType, DTSChannel channel) {
        this.env = env;
        this.dbName = dbName;
        this.subscriberId = subscriberId;
        this.tableName = tableName;
        this.ruleUUID = ruleUUID;
        this.optType = optType;
        this.channel = channel;
    }

    public DTSEnv getEnv() {
        return this.env;
    }

    public String getSubscriberId() {
        return this.subscriberId;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getRuleUUID() {
        return this.ruleUUID;
    }

    public DTSOptType getOptType() {
        return this.optType;
    }

    public DTSChannel getChannel() {
        return this.channel;
    }

    public Map<String, DTSRecordField> getFields() {
        return this.fields;
    }

    void setFields(Map<String, DTSRecordField> fields) {
        this.fields = fields;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[DTS Record]");
        if (this.env != null) {
            builder.append(" in ").append(this.env.name());
        }
        builder.append(" table: ").append(this.tableName).append(" fields: ");
        int i = 0;
        for (DTSRecordField field : this.fields.values()) {
            builder.append("[");
            builder.append(field.getName());
            builder.append(": ");
            builder.append(field.getValue());
            builder.append("]");
            if (i < this.fields.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.toString();
    }
}

