/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.exception;

import com.thebeastshop.dts.enums.DTSFieldType;
import org.apache.commons.lang3.StringUtils;

public class DTSParseValueException
extends RuntimeException {
    private final DTSFieldType type;
    private final String value;

    public DTSParseValueException(DTSFieldType type, String value) {
        super(DTSParseValueException.getMessage(type, value, null, null));
        this.type = type;
        this.value = value;
    }

    public DTSParseValueException(DTSFieldType type, String value, Throwable cause) {
        super(DTSParseValueException.getMessage(type, value, null, cause), cause);
        this.type = type;
        this.value = value;
    }

    private static String getMessage(DTSFieldType type, String value, String fieldName, Throwable cause) {
        String msg = "[DTS ERROR]: Parse";
        if (StringUtils.isNotBlank((CharSequence)fieldName)) {
            msg = msg + " Field [" + fieldName + "]";
        }
        msg = msg + " Value [" + value + "] of Type [" + type.name() + "] Error: ";
        if (cause != null) {
            msg = msg + "\n    \u7531\u4e8e: " + cause.getMessage() + "\n";
        }
        return msg;
    }

    public DTSFieldType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public String getMessageWithFieldName(String fieldName) {
        Throwable cause = this.getCause();
        if (cause == this || cause.getClass().equals(this.getClass())) {
            cause = null;
        }
        return DTSParseValueException.getMessage(this.type, this.value, fieldName, cause);
    }
}

