/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.zk;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.dts.exception.ZkConnectException;
import com.thebeastshop.dts.exception.ZkConnectionNotInitException;
import com.thebeastshop.dts.zk.DTSChildrenListener;
import com.thebeastshop.dts.zk.DTSListener;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.retry.RetryNTimes;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkDriver {
    private static Logger log = LoggerFactory.getLogger(ZkDriver.class);
    private static ZkDriver zkDriver;
    private CuratorFramework curatorClient;

    public static ZkDriver drive(String zkAddress) {
        if (zkDriver == null) {
            zkDriver = new ZkDriver(zkAddress);
        }
        return zkDriver;
    }

    public static ZkDriver drive() {
        return zkDriver;
    }

    private void validate() {
        if (this.curatorClient == null) {
            throw new ZkConnectionNotInitException("\u8bf7\u5148\u521d\u59cb\u5316zk\u8fde\u63a5");
        }
    }

    public boolean checkExist(String nodePath) {
        try {
            this.validate();
            return this.curatorClient.checkExists().forPath(nodePath) != null;
        }
        catch (Exception e) {
            throw new ZkConnectException("zk\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public List<String> getNodePathList(String parentPath) throws Exception {
        List paths = (List)this.curatorClient.getChildren().forPath(parentPath);
        return paths;
    }

    public String getNodeDataText(String nodePath) {
        try {
            this.validate();
            byte[] data = (byte[])this.curatorClient.getData().forPath(nodePath);
            if (data == null || data.length == 0) {
                return null;
            }
            return new String(data);
        }
        catch (Exception e) {
            throw new ZkConnectException("zk\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public <T> T getNodeData(String nodePath, Class<T> clazz) {
        try {
            String data = this.getNodeDataText(nodePath);
            return (T)JSON.parseObject((String)data, clazz);
        }
        catch (Exception e) {
            throw new ZkConnectException("zk\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public void putData2EphemeralNode(String nodePath, String data) {
        try {
            this.validate();
            if (!this.checkExist(nodePath)) {
                this.createEphemeralNode(nodePath, data);
            } else {
                this.curatorClient.setData().forPath(nodePath, data.getBytes());
            }
        }
        catch (Exception e) {
            throw new ZkConnectException("zk\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public void putData2Node(String nodePath, String data) {
        try {
            this.validate();
            if (!this.checkExist(nodePath)) {
                this.createNode(nodePath, data);
            } else {
                this.curatorClient.setData().forPath(nodePath, data.getBytes());
            }
        }
        catch (Exception e) {
            throw new ZkConnectException("zk\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public void createEphemeralNode(String nodePath, String data) {
        try {
            this.validate();
            ((ACLBackgroundPathAndBytesable)this.curatorClient.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(nodePath, data.getBytes());
        }
        catch (Exception e) {
            throw new ZkConnectException("zk\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public void createNode(String nodePath, String data) {
        try {
            this.validate();
            this.curatorClient.create().creatingParentsIfNeeded().forPath(nodePath, data.getBytes());
        }
        catch (Exception e) {
            throw new ZkConnectException("zk\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public void createListener(String nodePath, DTSListener listener, boolean executeOnStart) {
        try {
            NodeCache cache = new NodeCache(this.curatorClient, nodePath);
            listener.setCache(cache);
            cache.start(!executeOnStart);
            cache.getListenable().addListener((Object)listener);
        }
        catch (Exception e) {
            throw new ZkConnectException("zk\u8fde\u63a5\u5f02\u5e38", e);
        }
    }

    public void createListener(String nodePath, DTSListener listener) throws Exception {
        this.createListener(nodePath, listener, true);
    }

    public void createChildrenListener(String nodePath, DTSChildrenListener listener) throws Exception {
        PathChildrenCache cache = new PathChildrenCache(this.curatorClient, nodePath, true);
        cache.start();
        cache.getListenable().addListener((Object)listener);
    }

    public ZkDriver(String zkAddress) {
        this.curatorClient = CuratorFrameworkFactory.newClient((String)zkAddress, (RetryPolicy)new RetryNTimes(10, 5000));
        this.curatorClient.start();
    }
}

