/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.admin.feign;

import com.thebeastshop.dts.vo.AliyunDTSInfo;
import com.thebeastshop.dts.vo.AppConsumerDTO;
import com.thebeastshop.dts.vo.ClusterEnvDTO;
import com.thebeastshop.dts.vo.DTSApp;
import com.thebeastshop.dts.vo.DTSAppSimpleVO;
import com.thebeastshop.dts.vo.DTSOptResult;
import com.thebeastshop.dts.vo.DTSSearchResult;
import com.thebeastshop.dts.vo.DTSTableInfo;
import com.thebeastshop.dts.vo.DataRuleAddDTO;
import com.thebeastshop.dts.vo.DataRuleVO;
import com.thebeastshop.dts.vo.HistoryPageResult;
import com.thebeastshop.dts.vo.HistoryRecordQueryDTO;
import com.thebeastshop.dts.vo.PageQueryResult;
import com.thebeastshop.dts.vo.RecordDTO;
import com.thebeastshop.dts.vo.RecordQueryReqDTO;
import com.thebeastshop.dts.vo.SubscriberDTO;
import com.thebeastshop.dts.vo.SubscriberInstanceDTO;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

public interface DTSBaseFeignClient {
    @RequestMapping(value={"/app/{env}/list"}, method={RequestMethod.GET})
    public DTSOptResult<List<DTSApp>> findApps(@PathVariable(value="env") String var1);

    @RequestMapping(value={"/app/{env}/{appId}"}, method={RequestMethod.GET})
    public DTSOptResult<DTSApp> findApp(@PathVariable(value="env") String var1, @PathVariable(value="appId") String var2);

    @RequestMapping(value={"/search/{env}/{key}"}, method={RequestMethod.GET})
    public DTSOptResult<DTSSearchResult> searchAppOrSubscriber(@PathVariable(value="env") String var1, @PathVariable(value="key") String var2);

    @RequestMapping(value={"/autocomplete/{env}/{key}"}, method={RequestMethod.GET})
    public DTSOptResult<DTSSearchResult> autocomplete(@PathVariable(value="env") String var1, @PathVariable(value="key") String var2);

    @RequestMapping(value={"/subscriber/{env}/list"}, method={RequestMethod.GET})
    public DTSOptResult<List<SubscriberDTO>> findSubscriber(@PathVariable(value="env") String var1);

    @RequestMapping(value={"/subscriber/{env}/{uuid}"}, method={RequestMethod.GET})
    public DTSOptResult<SubscriberDTO> findSubscriberById(@PathVariable(value="env") String var1, @PathVariable(value="uuid") String var2);

    @RequestMapping(value={"/subscriber/{env}/add"}, method={RequestMethod.POST})
    public DTSOptResult<Map> addSubscriber(@PathVariable(value="env") String var1, @RequestBody SubscriberDTO var2);

    @RequestMapping(value={"/node/getHostInfo"}, method={RequestMethod.GET})
    public InetAddress getHostInfo();

    @RequestMapping(value={"/node/{env}/info"}, method={RequestMethod.GET})
    public ClusterEnvDTO getClusterEnvInfo(@PathVariable(value="env") String var1);

    @RequestMapping(value={"/node/{env}/{appId}/consumers"}, method={RequestMethod.GET})
    public List<AppConsumerDTO> getAppConsumers(@PathVariable(value="env") String var1, @PathVariable(value="appId") String var2);

    @RequestMapping(value={"/node/{env}/{appId}/local-debug-consumers"}, method={RequestMethod.GET})
    public List<AppConsumerDTO> getAppLocalDebugConsumers(@PathVariable(value="env") String var1, @PathVariable(value="appId") String var2);

    @RequestMapping(value={"/subscriber/{env}/{uuid}/cluster"}, method={RequestMethod.GET})
    public DTSOptResult<List<SubscriberInstanceDTO>> findSubscriberCluster(@PathVariable(value="env") String var1, @PathVariable(value="uuid") String var2);

    @RequestMapping(value={"/subscriber/start/{env}/{subscriberId}"}, method={RequestMethod.POST})
    public DTSOptResult<String> startSubscriber(@PathVariable(value="env") String var1, @PathVariable(value="subscriberId") String var2);

    @RequestMapping(value={"/subscriber/stop/{env}/{subscriberId}"}, method={RequestMethod.POST})
    public DTSOptResult<String> stopSubscriber(@PathVariable(value="env") String var1, @PathVariable(value="subscriberId") String var2);

    @RequestMapping(value={"/subscriber/aliyun/info/{env}/{subscriberId}"}, method={RequestMethod.GET})
    public DTSOptResult<AliyunDTSInfo> getAliyunDTSInfo(@PathVariable(value="env") String var1, @PathVariable(value="subscriberId") String var2);

    @RequestMapping(value={"/subscriber/aliyun/table/{env}/{subscriberId}"}, method={RequestMethod.GET})
    public DTSOptResult<List<DTSTableInfo>> getAliyunDTSTable(@PathVariable(value="env") String var1, @PathVariable(value="subscriberId") String var2);

    @RequestMapping(value={"/subscriber/aliyun/app/{env}/{subscriberId}"}, method={RequestMethod.GET})
    public DTSOptResult<List<DTSAppSimpleVO>> getAliyunDTSApp(@PathVariable(value="env") String var1, @PathVariable(value="subscriberId") String var2);

    @RequestMapping(value={"/subscriber/aliyun/datarule/{env}/{subscriberId}"}, method={RequestMethod.GET})
    public DTSOptResult<List<DataRuleVO>> getAliyunDTSDataRule(@PathVariable(value="env") String var1, @PathVariable(value="subscriberId") String var2);

    @RequestMapping(value={"/datarule/{env}/app/{app}"}, method={RequestMethod.GET})
    public DTSOptResult<List<DataRuleVO>> findDataRuleByApp(@PathVariable(value="env") String var1, @PathVariable(value="app") String var2);

    @RequestMapping(value={"/datarule/{env}/{uuid}"}, method={RequestMethod.GET})
    public DTSOptResult<DataRuleVO> getDataRule(@PathVariable(value="env") String var1, @PathVariable(value="uuid") String var2);

    @RequestMapping(value={"/datarule/{env}/list"}, method={RequestMethod.GET})
    public DTSOptResult<List<DataRuleVO>> findDataRule(@PathVariable(value="env") String var1);

    @RequestMapping(value={"/datarule/{env}/add"}, method={RequestMethod.GET})
    public DTSOptResult<Boolean> addDataRule(@PathVariable(value="env") String var1, @RequestBody DataRuleAddDTO var2);

    @RequestMapping(value={"/datarule/{env}/{uuid}/app/{appId}"}, method={RequestMethod.DELETE})
    public DTSOptResult<Boolean> deletDataRuleOfApp(@PathVariable(value="env") String var1, @PathVariable(value="uuid") String var2, @PathVariable(value="appId") String var3);

    @RequestMapping(value={"/record/retry/{env}/{recordId}"}, method={RequestMethod.GET})
    public DTSOptResult retry(@PathVariable(value="env") String var1, @PathVariable(value="recordId") String var2);

    @RequestMapping(value={"/record/skip/{env}/{recordId}"}, method={RequestMethod.GET})
    public DTSOptResult skip(@PathVariable(value="env") String var1, @PathVariable(value="recordId") String var2);

    @RequestMapping(value={"/record/list"}, method={RequestMethod.POST})
    public DTSOptResult<PageQueryResult<RecordDTO>> findRecordByCond(@RequestBody RecordQueryReqDTO var1);

    @RequestMapping(value={"/record/history/list"}, method={RequestMethod.POST})
    public DTSOptResult<HistoryPageResult> findHistoryRecordByCond(@RequestBody HistoryRecordQueryDTO var1);
}

