/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dts.admin.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.thebeastshop.dts.admin.DTSAdminHelper;
import com.thebeastshop.dts.admin.feign.DTSBaseFeignClient;
import com.thebeastshop.dts.admin.feign.DTSFeignClient;
import com.thebeastshop.dts.admin.feign.DTSFeignProClient;
import com.thebeastshop.dts.enums.DTSEnv;
import com.thebeastshop.dts.vo.AliyunDTSInfo;
import com.thebeastshop.dts.vo.AppConsumerDTO;
import com.thebeastshop.dts.vo.AutoCompleteVO;
import com.thebeastshop.dts.vo.ClusterEnvDTO;
import com.thebeastshop.dts.vo.ClusterInfo;
import com.thebeastshop.dts.vo.DTSApp;
import com.thebeastshop.dts.vo.DTSAppSimpleVO;
import com.thebeastshop.dts.vo.DTSOptResult;
import com.thebeastshop.dts.vo.DTSSearchResult;
import com.thebeastshop.dts.vo.DTSTableInfo;
import com.thebeastshop.dts.vo.DataRuleAddDTO;
import com.thebeastshop.dts.vo.DataRuleVO;
import com.thebeastshop.dts.vo.HistoryPageResult;
import com.thebeastshop.dts.vo.HistoryRecordQueryDTO;
import com.thebeastshop.dts.vo.HostDTO;
import com.thebeastshop.dts.vo.PageQueryResult;
import com.thebeastshop.dts.vo.RecordDTO;
import com.thebeastshop.dts.vo.RecordQueryReqDTO;
import com.thebeastshop.dts.vo.SubscriberClusterVO;
import com.thebeastshop.dts.vo.SubscriberDTO;
import com.thebeastshop.dts.vo.SubscriberInstanceDTO;
import com.thebeastshop.dts.vo.SubscriberSimpleVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
public class DTSApiController {
    @Resource
    private DTSFeignClient dtsFeignClient;
    @Resource
    private DTSFeignProClient dtsFeignProClient;
    @Resource
    private DiscoveryClient discoveryClient;
    @Resource
    private RestTemplate restTemplate;

    private DTSBaseFeignClient getFeignClient(String env) {
        if (StringUtils.isBlank((CharSequence)env)) {
            return this.dtsFeignClient;
        }
        String tmpEnv = env.trim().toUpperCase();
        if (DTSEnv.PRO.name().equals(tmpEnv)) {
            return this.dtsFeignProClient;
        }
        return this.dtsFeignClient;
    }

    private DTSBaseFeignClient getFeignClient(DTSEnv env) {
        if (env == null) {
            return this.dtsFeignClient;
        }
        return this.getFeignClient(env.name());
    }

    @RequestMapping(value={"app/{env}/list"}, method={RequestMethod.GET})
    public DTSOptResult<List<DTSApp>> findApps(@PathVariable(value="env") String env) {
        return this.getFeignClient(env).findApps(env);
    }

    @RequestMapping(value={"app/{env}/{appId}"}, method={RequestMethod.GET})
    public DTSOptResult<DTSApp> findApp(@PathVariable(value="env") String env, @PathVariable(value="appId") String appId) {
        return this.getFeignClient(env).findApp(env, appId);
    }

    @RequestMapping(value={"/app/{env}/datarule/{uuid}"}, method={RequestMethod.GET})
    public DTSOptResult<List<DTSApp>> findAppByDataRuleId(@PathVariable(value="env") String env, @PathVariable(value="uuid") String uuid) {
        DTSOptResult<DataRuleVO> dataRuleResult = this.getDataRule(env, uuid);
        if (dataRuleResult.getCode().equals("00")) {
            List appList = ((DataRuleVO)dataRuleResult.getData()).getAppList();
            ArrayList<Object> dtsAppList = new ArrayList<Object>();
            for (String app : appList) {
                dtsAppList.add(this.findApp(env, app).getData());
            }
            return DTSOptResult.successInstance(dtsAppList);
        }
        return DTSOptResult.failureInstance((String)"20");
    }

    @RequestMapping(value={"/app/{env}/subscriber/{subscriberId}"}, method={RequestMethod.GET})
    public DTSOptResult<List<DTSAppSimpleVO>> getAppListBySubscriberId(@PathVariable(value="env") String env, @PathVariable(value="subscriberId") String subscriberId) {
        return this.getFeignClient(env).getAliyunDTSApp(env, subscriberId);
    }

    @RequestMapping(value={"/search/{env}/{key}"}, method={RequestMethod.GET})
    public DTSOptResult<DTSSearchResult> searchAppOrSubscriber(@PathVariable(value="env") String env, @PathVariable(value="key") String key) {
        return this.getFeignClient(env).searchAppOrSubscriber(env, key);
    }

    @RequestMapping(value={"/autocomplete/{env}/{key}"}, method={RequestMethod.GET})
    public DTSOptResult<AutoCompleteVO> autocomplete(@PathVariable(value="env") String env, @PathVariable(value="key") String key) {
        DTSOptResult<DTSSearchResult> searchResult = this.getFeignClient(env).autocomplete(env, key);
        ArrayList<DTSAppSimpleVO> apps = new ArrayList<DTSAppSimpleVO>();
        if (CollectionUtils.isNotEmpty((Collection)((DTSSearchResult)searchResult.getData()).getApps())) {
            apps.addAll(Lists.transform((List)((DTSSearchResult)searchResult.getData()).getApps(), dtsApp -> new DTSAppSimpleVO(dtsApp.getAppId(), dtsApp.getAppName())));
        }
        if (((DTSSearchResult)searchResult.getData()).getApp() != null) {
            apps.add(new DTSAppSimpleVO(((DTSSearchResult)searchResult.getData()).getApp().getAppId(), ((DTSSearchResult)searchResult.getData()).getApp().getAppName()));
        }
        ArrayList<SubscriberSimpleVO> subscribers = new ArrayList<SubscriberSimpleVO>();
        if (CollectionUtils.isNotEmpty((Collection)((DTSSearchResult)searchResult.getData()).getSubscribers())) {
            subscribers.addAll(Lists.transform((List)((DTSSearchResult)searchResult.getData()).getSubscribers(), subscriberDTO -> new SubscriberSimpleVO(subscriberDTO.getUid(), subscriberDTO.getName(), subscriberDTO.getType())));
        }
        if (((DTSSearchResult)searchResult.getData()).getSubscriber() != null) {
            subscribers.add(new SubscriberSimpleVO(((DTSSearchResult)searchResult.getData()).getSubscriber().getUid(), ((DTSSearchResult)searchResult.getData()).getSubscriber().getName(), ((DTSSearchResult)searchResult.getData()).getSubscriber().getType()));
        }
        return DTSOptResult.successInstance((Object)new AutoCompleteVO(apps, subscribers));
    }

    @RequestMapping(value={"/subscriber/{env}/list"}, method={RequestMethod.GET})
    public DTSOptResult<List<SubscriberDTO>> findSubscriber(@PathVariable(value="env") String env) {
        return this.getFeignClient(env).findSubscriber(env);
    }

    @RequestMapping(value={"/subscriber/{env}/{uuid}"}, method={RequestMethod.GET})
    public DTSOptResult<SubscriberDTO> findSubscriberById(@PathVariable(value="env") String env, @PathVariable(value="uuid") String uuid) {
        return this.getFeignClient(env).findSubscriberById(env, uuid);
    }

    @RequestMapping(value={"/subscriber/{env}/add"}, method={RequestMethod.POST})
    DTSOptResult addSubscriber(@PathVariable(value="env") String env, @RequestBody SubscriberDTO config) {
        return this.getFeignClient(env).addSubscriber(env, config);
    }

    @RequestMapping(value={"/subscriber/status/{env}/{subscriberId}"}, method={RequestMethod.GET})
    public Map getAliyunDTSStatus(@PathVariable(value="env") String env, final @PathVariable(value="subscriberId") String subscriberId) {
        final DTSOptResult<AliyunDTSInfo> result = this.getAliyunDTSInfo(env, subscriberId);
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("subscriberId", subscriberId);
                this.put("status", ((AliyunDTSInfo)result.getData()).getStatus());
            }
        };
        return map;
    }

    @RequestMapping(value={"/cluster/{env}/info"}, method={RequestMethod.GET})
    public DTSOptResult<ClusterEnvDTO> getClusterEnvInfo(@PathVariable(value="env") String env) {
        ClusterEnvDTO clusterEnvDTO = this.getFeignClient(env).getClusterEnvInfo(env);
        return DTSOptResult.successInstance((Object)clusterEnvDTO);
    }

    @RequestMapping(value={"/cluster/{env}/{appId}/consumers"}, method={RequestMethod.GET})
    public DTSOptResult<List<AppConsumerDTO>> getAppConsumers(@PathVariable(value="env") String env, @PathVariable(value="appId") String appId) {
        List<AppConsumerDTO> appConsumers = this.getFeignClient(env).getAppConsumers(env, appId);
        return DTSOptResult.successInstance(appConsumers);
    }

    @RequestMapping(value={"/cluster/{env}/{appId}/local-debug-consumers"}, method={RequestMethod.GET})
    public DTSOptResult<List<AppConsumerDTO>> getAppLocalDebugConsumers(@PathVariable(value="env") String env, @PathVariable(value="appId") String appId) {
        List<AppConsumerDTO> appConsumers = this.getFeignClient(env).getAppLocalDebugConsumers(env, appId);
        return DTSOptResult.successInstance(appConsumers);
    }

    @RequestMapping(value={"/subscriber/cluster/{env}/{subscriberId}"}, method={RequestMethod.GET})
    public DTSOptResult<ClusterInfo> getClusterInfo(@PathVariable(value="env") String env, @PathVariable(value="subscriberId") String subscriberId) {
        DTSOptResult<AliyunDTSInfo> result = this.getAliyunDTSInfo(env, subscriberId);
        String consumptionClient = ((AliyunDTSInfo)result.getData()).getConsumptionClient();
        String masterClient = null;
        if (StringUtils.isNotBlank((CharSequence)consumptionClient)) {
            masterClient = consumptionClient.split(":")[0];
        }
        String serverName = DTSAdminHelper.getServerName(env);
        List hostList = this.discoveryClient.getInstances(serverName);
        HostDTO masterHost = null;
        ArrayList<HostDTO> slaveHosts = new ArrayList<HostDTO>();
        for (ServiceInstance host : hostList) {
            String url = "http://" + host.getHost() + ":" + host.getPort() + "/node/getHostInfo";
            HostDTO hostDTO = (HostDTO)this.restTemplate.getForObject(url, HostDTO.class, new Object[0]);
            if (hostDTO.getIp().equals(masterClient)) {
                masterHost = hostDTO;
                continue;
            }
            slaveHosts.add(hostDTO);
        }
        ClusterInfo clusterInfo = new ClusterInfo(masterHost, slaveHosts);
        return DTSOptResult.successInstance((Object)clusterInfo);
    }

    @RequestMapping(value={"/subscriber/cluster/instance/{env}/{subscriberId}"}, method={RequestMethod.GET})
    public DTSOptResult<SubscriberClusterVO> getSubscriberCluster(@PathVariable(value="env") String env, @PathVariable(value="subscriberId") String subscriberId) {
        DTSOptResult<List<SubscriberInstanceDTO>> instanceRet = this.getFeignClient(env).findSubscriberCluster(env, subscriberId);
        List instanceDTOList = (List)instanceRet.getData();
        SubscriberClusterVO subscriberClusterVO = new SubscriberClusterVO();
        ArrayList<SubscriberInstanceDTO> slaveInstances = new ArrayList<SubscriberInstanceDTO>();
        subscriberClusterVO.setSlaveInstances(slaveInstances);
        for (SubscriberInstanceDTO instanceDTO : instanceDTOList) {
            if (instanceDTO.isMaster()) {
                subscriberClusterVO.setMasterInstance(instanceDTO);
                continue;
            }
            slaveInstances.add(instanceDTO);
        }
        return DTSOptResult.successInstance((Object)subscriberClusterVO);
    }

    @RequestMapping(value={"/subscriber/start"}, method={RequestMethod.POST})
    public DTSOptResult<String> startSubscriber(@RequestBody JSONObject param) {
        String env = param.getString("env");
        String subscriberId = param.getString("subscriberId");
        return this.getFeignClient(env).startSubscriber(env, subscriberId);
    }

    @PostMapping(value={"/subscriber/stop"})
    public DTSOptResult<String> stopSubscriber(@RequestBody JSONObject param) {
        String env = param.getString("env");
        String subscriberId = param.getString("subscriberId");
        return this.getFeignClient(env).stopSubscriber(env, subscriberId);
    }

    @RequestMapping(value={"/subscriber/aliyun/info/{env}/{subscriberId}"}, method={RequestMethod.GET})
    public DTSOptResult<AliyunDTSInfo> getAliyunDTSInfo(@PathVariable(value="env") String env, @PathVariable(value="subscriberId") String subscriberId) {
        return this.getFeignClient(env).getAliyunDTSInfo(env, subscriberId);
    }

    @RequestMapping(value={"/subscriber/aliyun/table/{env}/{subscriberId}"}, method={RequestMethod.GET})
    public DTSOptResult<List<DTSTableInfo>> getAliyunDTSTable(@PathVariable(value="env") String env, @PathVariable(value="subscriberId") String subscriberId) {
        return this.getFeignClient(env).getAliyunDTSTable(env, subscriberId);
    }

    @RequestMapping(value={"/datarule/{env}/app/{appId}"}, method={RequestMethod.GET})
    public DTSOptResult<List<DataRuleVO>> findDataRuleByApp(@PathVariable(value="env") String env, @PathVariable(value="appId") String appId) {
        return this.getFeignClient(env).findDataRuleByApp(env, appId);
    }

    @RequestMapping(value={"/datarule/{env}/{uuid}"}, method={RequestMethod.GET})
    public DTSOptResult<DataRuleVO> getDataRule(@PathVariable(value="env") String env, @PathVariable(value="uuid") String uuid) {
        return this.getFeignClient(env).getDataRule(env, uuid);
    }

    @RequestMapping(value={"/datarule/{env}/list"}, method={RequestMethod.GET})
    public DTSOptResult<List<DataRuleVO>> findDataRule(@PathVariable(value="env") String env) {
        return this.getFeignClient(env).findDataRule(env);
    }

    @RequestMapping(value={"/datarule/{env}/add"}, method={RequestMethod.POST})
    public DTSOptResult<Boolean> addDataRule(@PathVariable(value="env") String env, @RequestBody DataRuleAddDTO dataRuleAddDTO) {
        return this.getFeignClient(env).addDataRule(env, dataRuleAddDTO);
    }

    @RequestMapping(value={"/datarule/{env}/{uuid}/app/{appId}/del"}, method={RequestMethod.POST})
    public DTSOptResult<Boolean> deleteDataRule(@PathVariable(value="env") String env, @PathVariable(value="uuid") String uuid, @PathVariable(value="appId") String appId) {
        return this.getFeignClient(env).deletDataRuleOfApp(env, uuid, appId);
    }

    @RequestMapping(value={"/datarule/{env}/subscriber/{subscriberId}"}, method={RequestMethod.GET})
    public DTSOptResult<List<DataRuleVO>> getAliyunDTSDataRule(@PathVariable(value="env") String env, @PathVariable(value="subscriberId") String subscriberId) {
        return this.getFeignClient(env).getAliyunDTSDataRule(env, subscriberId);
    }

    @RequestMapping(value={"/record/retry/{env}/{recordId}"}, method={RequestMethod.GET})
    public DTSOptResult retry(@PathVariable(value="env") String env, @PathVariable(value="recordId") String recordId) {
        return this.getFeignClient(env).retry(env, recordId);
    }

    @RequestMapping(value={"/record/skip/{env}/{recordId}"}, method={RequestMethod.GET})
    public DTSOptResult skip(@PathVariable(value="env") String env, @PathVariable(value="recordId") String recordId) {
        return this.getFeignClient(env).skip(env, recordId);
    }

    @PostMapping(value={"/record/list"})
    public DTSOptResult<PageQueryResult<RecordDTO>> findRecordByCond(@RequestBody RecordQueryReqDTO req) {
        DTSOptResult<PageQueryResult<RecordDTO>> rets = this.getFeignClient(req.getEnv()).findRecordByCond(req);
        return rets;
    }

    @PostMapping(value={"/record/history/list"})
    public DTSOptResult<HistoryPageResult> findHistoryRecordByCond(@RequestBody HistoryRecordQueryDTO cond) {
        DTSOptResult<HistoryPageResult> rets = this.getFeignClient(cond.getEnv()).findHistoryRecordByCond(cond);
        return rets;
    }
}

