/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dc.api.utils;

import cn.hutool.core.bean.BeanDesc;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.PropDesc;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.TypeUtil;
import com.alibaba.fastjson.JSON;
import com.thebeastshop.common.converter.GenericBeanConverter;
import com.thebeastshop.dc.api.annotation.DcId;
import com.thebeastshop.dc.api.annotation.DcTable;
import com.thebeastshop.dc.api.primary.DcGetter;
import com.thebeastshop.dc.api.vo.DcSalesOrderVO;
import com.thebeastshop.dc.api.vo.DcTableVO;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class QueryUtil {
    private static final Map<String, String> TABLE_FIELD_CACHE = new HashMap<String, String>();
    private static final Map<String, String> TABLE_FIELD_ALIAS_MAP = new HashMap<String, String>();

    private static void makeTableFieldCache(Class voClass, String alias) {
        Method[] methods;
        for (Method method : methods = voClass.getDeclaredMethods()) {
            Type voType;
            Type[] params;
            Type genType;
            String methodName = method.getName();
            String fieldName = QueryUtil.getterName(methodName);
            if (fieldName == null) continue;
            DcId idAnn = null;
            try {
                Field field = method.getDeclaringClass().getDeclaredField(fieldName);
                idAnn = field.getAnnotation(DcId.class);
            }
            catch (Throwable field) {
                // empty catch block
            }
            if (alias != null) {
                fieldName = alias + "." + fieldName;
            } else if (idAnn != null) {
                TABLE_FIELD_ALIAS_MAP.put(fieldName, "_id");
            }
            Class<?> type = method.getReturnType();
            if (DcTableVO.class.isAssignableFrom(type)) {
                TABLE_FIELD_CACHE.put(QueryUtil.getTableName(type), fieldName);
                QueryUtil.makeTableFieldCache(type, fieldName);
                continue;
            }
            if (!Collection.class.isAssignableFrom(type) || !((genType = method.getGenericReturnType()) instanceof ParameterizedType) || (params = ((ParameterizedType)genType).getActualTypeArguments()).length == 0 || !((voType = params[0]) instanceof Class)) continue;
            Class subVoClass = (Class)voType;
            TABLE_FIELD_CACHE.put(QueryUtil.getTableName(subVoClass), fieldName);
            QueryUtil.makeTableFieldCache(subVoClass, fieldName);
        }
    }

    private static boolean checkType(Class writeType, Class readType, Object obj) {
        Collection collection;
        if (writeType.isAssignableFrom(readType)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(writeType) && Boolean.class.isAssignableFrom(readType)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(readType) && Boolean.class.isAssignableFrom(writeType)) {
            return true;
        }
        if (GenericBeanConverter.isIntegerNumber((Class)writeType) && GenericBeanConverter.isIntegerNumber((Class)readType)) {
            return true;
        }
        if (GenericBeanConverter.isDecimalNumber((Class)readType) && GenericBeanConverter.isDecimalNumber((Class)writeType)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(readType) || Boolean.TYPE.isAssignableFrom(writeType)) {
            return true;
        }
        return Collection.class.isAssignableFrom(readType) && obj instanceof Collection && (collection = (Collection)obj).stream().allMatch(item -> QueryUtil.checkType(writeType, item.getClass(), item));
    }

    public static <R> void checkColumn(Class<? extends DcTableVO> voClass, R func, Object value) {
        if (value == null) {
            return;
        }
        if (func == null) {
            throw new RuntimeException("[DC\u67e5\u8be2\u9519\u8bef] \u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!(func instanceof DcGetter)) {
            throw new RuntimeException("[DC\u67e5\u8be2\u9519\u8bef] \u4e0d\u652f\u6301\u8be5\u5b57\u6bb5\u7c7b\u578b");
        }
        Class<?> valueType = value.getClass();
        String getter = QueryUtil.getColumnGetter(func);
        Method method = null;
        try {
            method = voClass.getDeclaredMethod(getter, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        Class<?> columnType = method.getReturnType();
        if (value instanceof Collection) {
            Collection valueCollection = (Collection)value;
            int i = 0;
            for (Object item : valueCollection) {
                if (!QueryUtil.checkType(columnType, item.getClass(), item)) {
                    throw new RuntimeException("[DC\u67e5\u8be2\u9519\u8bef] \u67e5\u8be2\u63d0\u4ea4\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d: \u65b9\u6cd5 " + voClass.getName() + "." + getter + "() \u8fd4\u56de\u7c7b\u578b\u4e3a " + columnType.getName() + ", \u800c\u53c2\u6570\u503c (" + JSON.toJSONString((Object)value) + ") \u7684\u7b2c " + i + " \u9879\u7c7b\u578b\u4e3a " + valueType.getName() + "");
                }
                ++i;
            }
        } else if (!columnType.isAssignableFrom(valueType)) {
            throw new RuntimeException("[DC\u67e5\u8be2\u9519\u8bef] \u67e5\u8be2\u63d0\u4ea4\u53c2\u6570\u7c7b\u578b\u4e0d\u5339\u914d: \u65b9\u6cd5 " + voClass.getName() + "." + getter + "() \u8fd4\u56de\u7c7b\u578b\u4e3a " + columnType.getName() + ", \u800c\u53c2\u6570\u503c (" + value + ") \u7c7b\u578b\u4e3a " + valueType.getName() + "");
        }
    }

    public static <R> String getColumnName(Class<? extends DcTableVO> voClass, R func) {
        String tableName = QueryUtil.getTableName(voClass);
        String prefix = TABLE_FIELD_CACHE.get(tableName);
        return QueryUtil.getColumnName(prefix, func);
    }

    public static List<String> listColumnNamesOfTable(Class<? extends DcTableVO> voClass) {
        LinkedList<String> columNames = new LinkedList<String>();
        String tableName = QueryUtil.getTableName(voClass);
        String prefix = TABLE_FIELD_CACHE.get(tableName);
        BeanDesc desc = BeanUtil.getBeanDesc(voClass);
        for (PropDesc prop : desc.getProps()) {
            Type argType;
            Class argClass;
            Type propType;
            ParameterizedType parameterizedType;
            Class propClass = prop.getFieldClass();
            if (!ClassUtil.isSimpleTypeOrArray((Class)propClass) || (parameterizedType = TypeUtil.toParameterizedType((Type)(propType = prop.getFieldType()))) != null && parameterizedType.getActualTypeArguments().length > 0 && (Collection.class.isAssignableFrom(propClass) && !ClassUtil.isSimpleValueType((Class)(argClass = TypeUtil.getClass((Type)(argType = parameterizedType.getActualTypeArguments()[0])))) || Map.class.isAssignableFrom(propClass) && parameterizedType.getActualTypeArguments().length == 2 && !ClassUtil.isSimpleValueType((Class)(argClass = TypeUtil.getClass((Type)(argType = parameterizedType.getActualTypeArguments()[1])))))) continue;
            String fieldName = prop.getFieldName();
            String columnName = QueryUtil.getColumnName(prefix, fieldName);
            columNames.add(columnName);
        }
        return columNames;
    }

    public static String getJoinPath(Class<? extends DcTableVO> voClass) {
        String tableName = QueryUtil.getTableName(voClass);
        return TABLE_FIELD_CACHE.get(tableName);
    }

    public static <R> String getColumnGetter(R func) {
        if (!(func instanceof DcGetter)) {
            throw new RuntimeException("not support this type of column");
        }
        try {
            Method method = func.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(func, new Object[0]);
            return serializedLambda.getImplMethodName();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getColumnName(String prefix, String getterName) {
        String columnName = null;
        columnName = prefix != null && prefix.length() > 0 ? prefix + "." + getterName : getterName;
        String alias = TABLE_FIELD_ALIAS_MAP.get(columnName);
        if (alias != null) {
            return alias;
        }
        return columnName;
    }

    public static <R> String getColumnName(String prefix, R func) {
        if (!(func instanceof DcGetter)) {
            throw new RuntimeException("not support this type of column");
        }
        String getter = QueryUtil.getColumnGetter(func);
        String getterName = QueryUtil.getterName(getter);
        if (getterName == null) {
            throw new RuntimeException("[DC\u67e5\u8be2\u9519\u8bef] " + getter + " \u4e0d\u662f\u4e00\u4e2a Getter \u65b9\u6cd5!");
        }
        String fieldName = null;
        fieldName = prefix != null && prefix.length() > 0 ? prefix + "." + QueryUtil.getterName(getter) : QueryUtil.getterName(getter);
        String alias = TABLE_FIELD_ALIAS_MAP.get(fieldName);
        if (alias != null) {
            return alias;
        }
        return fieldName;
    }

    public static String getterName(String getMethodName) {
        if (getMethodName.startsWith("get")) {
            getMethodName = getMethodName.substring(3);
        } else if (getMethodName.startsWith("is")) {
            getMethodName = getMethodName.substring(2);
        } else {
            return null;
        }
        return QueryUtil.firstToLowerCase(getMethodName);
    }

    private static String firstToLowerCase(String param) {
        if (Objects.isNull(param) || "".equals(param)) {
            return "";
        }
        return param.substring(0, 1).toLowerCase() + param.substring(1);
    }

    public static String getTableName(Class<?> voClass) {
        DcTable ann = voClass.getAnnotation(DcTable.class);
        if (ann != null) {
            DcTable dcTableAnn = ann;
            return dcTableAnn.value();
        }
        return null;
    }

    static {
        QueryUtil.makeTableFieldCache(DcSalesOrderVO.class, null);
    }
}

