/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dc.api.searcher;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.common.validation.Validation;
import com.thebeastshop.dc.api.dto.DcAggDTO;
import com.thebeastshop.dc.api.dto.DcAggResultDTO;
import com.thebeastshop.dc.api.dto.DcMetricsDTO;
import com.thebeastshop.dc.api.dto.DcPageDTO;
import com.thebeastshop.dc.api.dto.DcQueryDTO;
import com.thebeastshop.dc.api.primary.DcLambdaAgg;
import com.thebeastshop.dc.api.primary.DcLambdaQuery;
import com.thebeastshop.dc.api.searcher.DcAbstractSearcher;
import com.thebeastshop.dc.api.service.DcQueryDubboService;
import com.thebeastshop.dc.api.vo.DcSalesOrderVO;
import com.thebeastshop.dc.api.vo.DcTableVO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcSalesOrderSearcher
extends DcAbstractSearcher<DcSalesOrderVO> {
    private static final Logger logger = LoggerFactory.getLogger(DcSalesOrderSearcher.class);

    public DcSalesOrderSearcher(DcQueryDubboService dcQueryDubboService) {
        super(dcQueryDubboService, DcSalesOrderVO.class);
    }

    public DcSalesOrderVO selectById(Integer id) {
        Validation.paramNotNull((Object)id, (String)"\u53c2\u6570 id \u4e3a\u7a7a");
        return this.dcQueryDubboService.getSalesOrderById(id);
    }

    public DcSalesOrderVO selectByCode(String code) {
        Validation.paramNotNull((Object)code, (String)"\u53c2\u6570 code \u4e3a\u7a7a");
        DcLambdaQuery query = (DcLambdaQuery)((DcLambdaQuery)new DcLambdaQuery<DcSalesOrderVO>(DcSalesOrderVO.class).eq(DcSalesOrderVO::getCode, (Object)code)).size(1);
        DcQueryDTO dto = query.toDTO();
        logger.info("[DC\u67e5\u8be2]\n====> DC Query DSL: " + JSON.toJSONString((Object)dto));
        return this.dcQueryDubboService.selectOneSalesOrder(dto);
    }

    public DcSalesOrderVO selectByCodeOrSync(String code) {
        Validation.paramNotNull((Object)code, (String)"\u53c2\u6570 code \u4e3a\u7a7a");
        DcLambdaQuery query = (DcLambdaQuery)((DcLambdaQuery)new DcLambdaQuery<DcSalesOrderVO>(DcSalesOrderVO.class).eq(DcSalesOrderVO::getCode, (Object)code)).size(1);
        DcQueryDTO dto = query.toDTO();
        logger.info("[DC\u67e5\u8be2]\n====> DC Query DSL: " + JSON.toJSONString((Object)dto));
        return this.dcQueryDubboService.selectOneSalesOrderOrSync(dto);
    }

    public Boolean isExist(String code) {
        logger.info("[DC\u67e5\u8be2]\n====> \u8ba2\u5355\u53f7\u662f\u5426\u5b58\u5728: " + code);
        return this.dcQueryDubboService.exist(code);
    }

    public Integer countOf(DcLambdaQuery<DcSalesOrderVO> query) {
        Validation.paramNotNull(query, (String)"\u53c2\u6570 query \u4e3a\u7a7a");
        DcQueryDTO dto = query.toDTO();
        logger.info("[DC\u67e5\u8be2]\n====> \u6570\u91cf\u67e5\u8be2: DC Query DSL: " + JSON.toJSONString((Object)dto));
        return this.dcQueryDubboService.countOf(dto);
    }

    public List<DcSalesOrderVO> selectByIdList(List<Integer> idList) {
        DcLambdaQuery<DcSalesOrderVO> query = new DcLambdaQuery<DcSalesOrderVO>(DcSalesOrderVO.class);
        ((DcLambdaQuery)query.in(DcSalesOrderVO::getId, (Collection)idList)).size(idList.size());
        DcQueryDTO dto = query.toDTO();
        logger.info("[DC\u67e5\u8be2]\n====> DC Query DSL: " + JSON.toJSONString((Object)dto));
        DcPageDTO<DcSalesOrderVO> pageDTO = this.dcQueryDubboService.selectSalesOrderList(dto);
        if (pageDTO == null) {
            return new ArrayList<DcSalesOrderVO>();
        }
        return pageDTO.getData();
    }

    public List<DcSalesOrderVO> selectByCodeList(List<String> codeList) {
        DcLambdaQuery<DcSalesOrderVO> query = new DcLambdaQuery<DcSalesOrderVO>(DcSalesOrderVO.class);
        ((DcLambdaQuery)query.in(DcSalesOrderVO::getCode, (Collection)codeList)).size(codeList.size());
        DcQueryDTO dto = query.toDTO();
        logger.info("[DC\u67e5\u8be2]\n====> DC Query DSL: " + JSON.toJSONString((Object)dto));
        DcPageDTO<DcSalesOrderVO> pageDTO = this.dcQueryDubboService.selectSalesOrderList(dto);
        if (pageDTO == null) {
            return new ArrayList<DcSalesOrderVO>();
        }
        return pageDTO.getData();
    }

    public DcSalesOrderVO selectOne(DcLambdaQuery<DcSalesOrderVO> query) {
        Validation.paramNotNull(query, (String)"\u53c2\u6570 query \u4e3a\u7a7a");
        DcQueryDTO dto = query.toDTO();
        logger.info("[DC\u67e5\u8be2]\n====> DC Query DSL: " + JSON.toJSONString((Object)dto));
        return this.dcQueryDubboService.selectOneSalesOrder(dto);
    }

    public DcPageDTO<DcSalesOrderVO> selectList(DcLambdaQuery<DcSalesOrderVO> query) {
        Validation.paramNotNull(query, (String)"\u53c2\u6570 query \u4e3a\u7a7a");
        DcQueryDTO dto = query.toDTO();
        logger.info("[DC\u67e5\u8be2]\n====> DC Query DSL: " + JSON.toJSONString((Object)dto));
        return this.dcQueryDubboService.selectSalesOrderList(dto);
    }

    DcAggResultDTO aggregation(DcLambdaQuery<DcSalesOrderVO> query, List<DcLambdaAgg<? extends DcTableVO>> aggs) {
        DcQueryDTO queryDTO = query.toDTO();
        DcAggDTO aggDTO = new DcAggDTO();
        LinkedHashMap<String, DcMetricsDTO> map = new LinkedHashMap<String, DcMetricsDTO>();
        for (DcLambdaAgg<? extends DcTableVO> agg : aggs) {
            DcAggDTO dto = agg.toDTO();
            map.putAll(dto.getMetrics());
        }
        aggDTO.setMetrics(map);
        logger.info("[DC\u805a\u5408\u67e5\u8be2]\n====> DC Query DSL: " + JSON.toJSONString((Object)queryDTO) + ", DC Agg DSL: " + JSON.toJSONString((Object)aggDTO));
        return this.dcQueryDubboService.aggregate(queryDTO, aggDTO);
    }

    public DcAggResultDTO aggregation(DcLambdaQuery<DcSalesOrderVO> query, DcLambdaAgg<? extends DcTableVO> ... aggs) {
        return this.aggregation(query, Arrays.asList(aggs));
    }
}

