/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.dc.api.primary;

import com.thebeastshop.dc.api.dto.DcCompareDTO;
import com.thebeastshop.dc.api.dto.DcConditionDTO;
import com.thebeastshop.dc.api.dto.DcQueryDTO;
import com.thebeastshop.dc.api.dto.DcSelectionDTO;
import com.thebeastshop.dc.api.dto.DcSortDTO;
import com.thebeastshop.dc.api.primary.AbstractWhere;
import com.thebeastshop.dc.api.primary.DcCompare;
import com.thebeastshop.dc.api.primary.DcGetter;
import com.thebeastshop.dc.api.primary.DcOp;
import com.thebeastshop.dc.api.primary.DcParam;
import com.thebeastshop.dc.api.primary.DcQuery;
import com.thebeastshop.dc.api.primary.DcSort;
import com.thebeastshop.dc.api.utils.QueryUtil;
import com.thebeastshop.dc.api.vo.DcTableVO;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public abstract class AbstractQuery<SELF extends AbstractQuery<SELF, TABLE, COLUMN>, TABLE extends DcTableVO, COLUMN>
implements DcQuery<SELF, TABLE, COLUMN> {
    protected final SELF self = this;
    protected final Class<TABLE> tableClass;
    private Integer offset;
    private Integer size;
    private final List<COLUMN> includeList = new LinkedList<COLUMN>();
    private final List<COLUMN> excludeList = new LinkedList<COLUMN>();
    private final List<Class> includeTableList = new LinkedList<Class>();
    private final List<Class> excludeTableList = new LinkedList<Class>();
    private final List<DcParam> paramList = new LinkedList<DcParam>();
    private final List<DcParam> matchList = new LinkedList<DcParam>();
    private final List<Function> orList = new LinkedList<Function>();
    private final List<Function> notList = new LinkedList<Function>();
    private final List<DcParam> notParamList = new LinkedList<DcParam>();
    private final List<DcSort> sortList = new LinkedList<DcSort>();

    protected AbstractQuery(Class<TABLE> tableClass) {
        this.tableClass = tableClass;
    }

    Class<TABLE> getTableClass() {
        return this.tableClass;
    }

    @Override
    public <OTHER_TABLE extends DcTableVO> SELF oneToOne(DcGetter<TABLE, OTHER_TABLE> joinColumn) {
        return this.self;
    }

    @Override
    public <OTHER_TABLE extends DcTableVO, COLLECTION extends Collection<OTHER_TABLE>> SELF oneToMany(DcGetter<TABLE, COLLECTION> joinColumn) {
        return this.self;
    }

    private static <T extends DcTableVO, Q extends AbstractQuery> Q newInstance(Class<Q> queryClass, Class<T> tableClass) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<Q> constructor = queryClass.getConstructor(Class.class);
        return (Q)((AbstractQuery)constructor.newInstance(tableClass));
    }

    protected abstract <T extends DcTableVO> AbstractWhere createWhere(Class<T> var1);

    @Override
    public SELF selectAllColumns() {
        this.includeList.clear();
        this.excludeList.clear();
        return this.self;
    }

    @Override
    @SafeVarargs
    public final SELF notSelect(COLUMN ... columns) {
        this.excludeList.addAll(Arrays.asList(columns));
        return this.self;
    }

    @Override
    public SELF selectAllTables() {
        this.includeTableList.clear();
        this.excludeTableList.clear();
        return this.self;
    }

    @Override
    @SafeVarargs
    public final SELF select(Class<TABLE> ... tableClasses) {
        this.includeTableList.addAll(Arrays.asList(tableClasses));
        return this.self;
    }

    @Override
    @SafeVarargs
    public final <T extends DcTableVO> SELF notSelect(Class<T> ... tableClasses) {
        this.excludeTableList.addAll(Arrays.asList(tableClasses));
        return this.self;
    }

    @Override
    public SELF limit(Integer from, int size) {
        this.offset = from;
        this.size = size;
        return this.self;
    }

    @Override
    public SELF limit(int size) {
        this.size = size;
        return this.self;
    }

    public SELF offset(int offset) {
        this.offset = offset;
        return this.self;
    }

    public Integer offset() {
        return this.offset;
    }

    public SELF size(int size) {
        this.size = size;
        return this.self;
    }

    public Integer size() {
        return this.size;
    }

    @Override
    public SELF sort(DcSort ... sorts) {
        for (DcSort sort : sorts) {
            this.sortList.add(sort);
        }
        return this.self;
    }

    private SELF addCompare(COLUMN column, DcOp op, Object value) {
        QueryUtil.checkColumn(this.tableClass, column, value);
        this.paramList.add(new DcCompare<COLUMN>(column, op, value));
        return this.self;
    }

    private SELF addMatch(COLUMN column, DcOp op, Object value) {
        QueryUtil.checkColumn(this.tableClass, column, value);
        this.matchList.add(new DcCompare<COLUMN>(column, op, value));
        return this.self;
    }

    @Override
    public SELF eq(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.EQ, value);
    }

    @Override
    public SELF ne(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.NE, value);
    }

    @Override
    public SELF gt(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.GT, value);
    }

    @Override
    public SELF ge(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.GE, value);
    }

    @Override
    public SELF lt(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.LT, value);
    }

    @Override
    public SELF le(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.LE, value);
    }

    @Override
    public SELF in(COLUMN column, Object ... values) {
        return this.addCompare(column, DcOp.IN, Arrays.asList(values));
    }

    @Override
    public SELF in(COLUMN column, Collection values) {
        return this.addCompare(column, DcOp.IN, values);
    }

    @Override
    public SELF exists(COLUMN column) {
        return this.addCompare(column, DcOp.EXISTS, 0);
    }

    @Override
    public SELF match(COLUMN column, Object value) {
        return this.addMatch(column, DcOp.MATCH, value);
    }

    @Override
    public SELF matchPrefix(COLUMN column, Object value) {
        return this.addMatch(column, DcOp.MATCH_PREFIX, value);
    }

    @Override
    public SELF like(COLUMN column, Object value) {
        return this.addCompare(column, DcOp.LIKE, value);
    }

    @Override
    public SELF notIn(COLUMN column, Object ... values) {
        return this.addCompare(column, DcOp.NOT_IN, values);
    }

    @Override
    public SELF notExists(COLUMN column) {
        return this.addCompare(column, DcOp.NOT_EXISTS, 0);
    }

    @Override
    public SELF notMatch(COLUMN column, Object value) {
        return this.addMatch(column, DcOp.NOT_MATCH, value);
    }

    @Override
    public SELF notMatchPrefix(COLUMN column, Object value) {
        return this.addMatch(column, DcOp.NOT_MATCH_PREFIX, value);
    }

    @Override
    public final SELF not(Function<SELF, SELF> condition) {
        this.notList.add(condition);
        return this.self;
    }

    @Override
    @SafeVarargs
    public final SELF or(Function<SELF, SELF> ... conditions) {
        this.orList.addAll(Arrays.asList(conditions));
        return this.self;
    }

    @Override
    public DcQueryDTO toDTO() {
        Object ret;
        DcQueryDTO dto = new DcQueryDTO();
        if (this.offset != null) {
            dto.setOffset(this.offset);
        }
        if (this.size != null) {
            dto.setSize(this.size);
        }
        if (CollectionUtils.isNotEmpty(this.sortList)) {
            dto.setSorts(this.sortList.stream().map(sort -> {
                DcSortDTO sortDTO = new DcSortDTO();
                sortDTO.setType(sort.getType());
                sortDTO.setColumn(QueryUtil.getColumnName(this.tableClass, sort.getColumn()));
                return sortDTO;
            }).collect(Collectors.toList()));
        }
        DcSelectionDTO selectionDTO = new DcSelectionDTO();
        for (COLUMN column : this.includeList) {
            selectionDTO.addColumn(QueryUtil.getColumnName(this.tableClass, column));
        }
        for (COLUMN column : this.excludeList) {
            selectionDTO.addColumn(QueryUtil.getColumnName(this.tableClass, column));
        }
        dto.setSelect(selectionDTO);
        DcConditionDTO conditionDTO = new DcConditionDTO();
        dto.setCond(conditionDTO);
        for (DcParam param : this.paramList) {
            if (!(param instanceof DcCompare)) continue;
            DcCompare compare = (DcCompare)param;
            DcCompareDTO compareDTO = compare.toDTO(this.tableClass);
            if (compare.isNegative()) {
                conditionDTO.addNot(compareDTO);
                continue;
            }
            if (compare.isMatch()) {
                conditionDTO.addMatch(compareDTO);
                continue;
            }
            conditionDTO.addAnd(compareDTO);
        }
        for (Function not : this.notList) {
            try {
                Object notQuery = AbstractQuery.newInstance(this.getClass(), this.tableClass);
                ret = not.apply(notQuery);
                if (ret instanceof AbstractQuery) {
                    notQuery = (AbstractQuery)ret;
                }
                conditionDTO.addNot(((AbstractQuery)notQuery).toDTO().getCond());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        for (Function or : this.orList) {
            try {
                Object orQuery = AbstractQuery.newInstance(this.getClass(), this.tableClass);
                ret = or.apply(orQuery);
                if (ret instanceof AbstractQuery) {
                    orQuery = (AbstractQuery)ret;
                }
                conditionDTO.addOr(((AbstractQuery)orQuery).toDTO().getCond());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return dto;
    }
}

