/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.gateway.common;

import com.thebeastshop.datahub.common.api.Result;
import com.thebeastshop.datahub.core.exception.BusinessException;
import com.thebeastshop.datahub.gateway.common.ResultSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @ResponseStatus(value=HttpStatus.OK)
    @ExceptionHandler(value={BusinessException.class})
    public Result handleBizError(BusinessException ex) {
        this.log.error("\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)ex);
        return ResultSupport.biz_error(ex.getError());
    }

    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ExceptionHandler(value={Exception.class})
    public Result handleServerError(Exception ex) {
        this.log.error("\u7cfb\u7edf\u5f02\u5e38\uff1a", (Throwable)ex);
        return ResultSupport.internal_server_error();
    }
}

