/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.dao.impl;

import com.alibaba.dubbo.common.utils.ConcurrentHashSet;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.datahub.common.api.QueryResult;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.enums.CriteriaOperatorEnum;
import com.thebeastshop.datahub.common.enums.DataTypeEnum;
import com.thebeastshop.datahub.common.vo.AggregationResult;
import com.thebeastshop.datahub.common.vo.BusinessProperty;
import com.thebeastshop.datahub.common.vo.BusinessRecord;
import com.thebeastshop.datahub.common.vo.BusinessStruct;
import com.thebeastshop.datahub.dao.BusinessRecordDao;
import com.thebeastshop.datahub.dao.exception.DatahubQueryException;
import com.thebeastshop.datahub.dao.support.AggregationSupport;
import com.thebeastshop.datahub.dao.support.QuerySupport;
import com.thebeastshop.kit.id.UniqueIdGenerator;
import com.thebeastshop.kit.prop.PropConstants;
import com.thebeastshop.kit.prop.annotation.DynamicPropValue;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.AggregationClient;
import org.apache.hadoop.hbase.client.coprocessor.LongColumnInterpreter;
import org.apache.hadoop.hbase.coprocessor.ColumnInterpreter;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class HBaseBusinessRecordDao
implements BusinessRecordDao {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String BIZ_STRUCT = "s";
    public static final String BIZ_STRUCT_NAME = "sn";
    public static final String TABLE_NAME_PREFIX = "datahub-";
    public static final String COMMON_COLUMN_FAMILY = "c";
    public static final String BIZ_COLUMN_FAMILY = "b";
    public static final String COLUMN_ROW_KEY = "rowKey";
    @DynamicPropValue(value="hbase.zookeeper.quorum")
    private String zookeeperQuorum;
    @DynamicPropValue(value="hbase.zookeeper.property.clientPort")
    private String zookeeperPropertyClientPort;
    @DynamicPropValue(value="hbase.maxPageSize")
    private long maxPageSize;
    private Connection connection;
    private AggregationClient aggregationClient;
    private ConcurrentHashSet<String> tableNames = new ConcurrentHashSet();

    public long getActualPageSize(Long pageSize) {
        if (pageSize == null) {
            return this.maxPageSize;
        }
        return Math.min(pageSize, this.maxPageSize);
    }

    @PostConstruct
    private void init() throws IOException {
        Configuration config = HBaseConfiguration.create();
        if (StringUtils.isNotBlank((CharSequence)this.zookeeperQuorum)) {
            config.set("hbase.zookeeper.quorum", this.zookeeperQuorum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.zookeeperPropertyClientPort)) {
            config.set("hbase.zookeeper.property.clientPort", this.zookeeperPropertyClientPort);
        }
        Configuration conf = HBaseConfiguration.create((Configuration)config);
        this.aggregationClient = new AggregationClient(conf);
        this.connection = ConnectionFactory.createConnection((Configuration)config);
        try (Admin admin = this.connection.getAdmin();){
            TableName[] names;
            for (TableName name : names = admin.listTableNames()) {
                this.tableNames.add((Object)name.getNameAsString());
            }
        }
    }

    private String getTableName(String appId) {
        if (StringUtils.isBlank((CharSequence)appId)) {
            this.log.error("appId is blank");
            return null;
        }
        String tn = TABLE_NAME_PREFIX + appId.toLowerCase().trim();
        String env = PropConstants.getEnv((Properties)System.getProperties());
        if (!env.equals("prod")) {
            tn = tn + "-" + env;
        }
        this.log.info("HBase table name: {}", (Object)tn);
        return tn;
    }

    private boolean tableExists(String tbName) {
        if (StringUtils.isBlank((CharSequence)tbName)) {
            return false;
        }
        return this.tableNames.contains((Object)tbName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tableExistsOrCreate(String tbName) {
        if (StringUtils.isBlank((CharSequence)tbName)) {
            return false;
        }
        if (this.tableNames.contains((Object)tbName)) return true;
        ConcurrentHashSet<String> concurrentHashSet = this.tableNames;
        synchronized (concurrentHashSet) {
            if (this.tableNames.contains((Object)tbName)) return true;
            try (Admin admin = this.connection.getAdmin();){
                if (admin.tableExists(TableName.valueOf((String)tbName))) {
                    boolean bl = true;
                    return bl;
                }
                TableName tableName = TableName.valueOf((String)tbName);
                HTableDescriptor desc = new HTableDescriptor(tableName);
                desc.addFamily(new HColumnDescriptor(COMMON_COLUMN_FAMILY.getBytes()));
                desc.addFamily(new HColumnDescriptor(BIZ_COLUMN_FAMILY.getBytes()));
                String coprocessorClass = "org.apache.hadoop.hbase.coprocessor.AggregateImplementation";
                if (!desc.hasCoprocessor(coprocessorClass)) {
                    desc.addCoprocessor(coprocessorClass);
                }
                admin.createTable(desc);
                this.tableNames.add((Object)tbName);
            }
            catch (IOException e) {
                this.log.error("tableExistsOrCreate\u521b\u5efa\u8868\u5931\u8d25, tableName: {}", (Object)tbName, (Object)e);
            }
            return true;
        }
    }

    private Put convertVO2Put(BusinessRecord vo) {
        Date updateTime;
        if (vo == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)vo.getId())) {
            vo.setId(UniqueIdGenerator.generateId().toString());
        }
        Put put = new Put(DataTypeEnum.getEnumByType(vo.getId().getClass()).object2Bytes((Object)vo.getId()));
        Date createTime = updateTime = new Date();
        for (Field field : vo.getClass().getDeclaredFields()) {
            String cf;
            Object v;
            field.setAccessible(true);
            String name = field.getName();
            try {
                v = field.get(vo);
            }
            catch (IllegalAccessException e) {
                this.log.error("\u83b7\u53d6Field\u503c\u5931\u8d25, fieldName: {}", (Object)name, (Object)e);
                continue;
            }
            if (v == null) continue;
            if (field.getType().equals(BusinessStruct.class)) {
                BusinessStruct struct = (BusinessStruct)v;
                if (StringUtils.isBlank((CharSequence)struct.getName())) {
                    throw new NoSuchFieldError("business struct name is blank");
                }
                put.addColumn(COMMON_COLUMN_FAMILY.getBytes(), BIZ_STRUCT_NAME.getBytes(), struct.getName().getBytes());
                put.addColumn(COMMON_COLUMN_FAMILY.getBytes(), BIZ_STRUCT.getBytes(), JSON.toJSONString((Object)v).getBytes());
                cf = BIZ_COLUMN_FAMILY;
                if (!CollectionUtils.isNotEmpty((Collection)struct.getProperties())) continue;
                for (BusinessProperty property : struct.getProperties()) {
                    if (property.getValue() == null) continue;
                    put.addColumn(cf.getBytes(), property.getName().getBytes(), property.getDataType().object2Bytes(property.getValue()));
                }
                continue;
            }
            cf = COMMON_COLUMN_FAMILY;
            put.addColumn(cf.getBytes(), name.getBytes(), DataTypeEnum.getEnumByType(field.getType()).object2Bytes(v));
        }
        return put;
    }

    private BusinessRecord handleResult(Result result) {
        if (result == null || result.isEmpty()) {
            return null;
        }
        BusinessRecord po = new BusinessRecord();
        for (Field field : po.getClass().getDeclaredFields()) {
            String cf;
            field.setAccessible(true);
            String name = field.getName();
            if (field.getType().equals(BusinessStruct.class)) {
                String structJsonString = new String(result.getValue(COMMON_COLUMN_FAMILY.getBytes(), BIZ_STRUCT.getBytes()));
                if (StringUtils.isBlank((CharSequence)structJsonString)) continue;
                cf = BIZ_COLUMN_FAMILY;
                NavigableMap familyMap = result.getFamilyMap(cf.getBytes());
                BusinessStruct struct = (BusinessStruct)JSON.parseObject((String)structJsonString, BusinessStruct.class);
                if (CollectionUtils.isNotEmpty((Collection)struct.getProperties())) {
                    for (BusinessProperty property : struct.getProperties()) {
                        property.setValue(property.getDataType().bytes2Object((byte[])familyMap.get(property.getName().getBytes())));
                    }
                }
                try {
                    field.set(po, struct);
                }
                catch (IllegalAccessException e) {
                    this.log.error("\u8bbe\u7f6e\u4e1a\u52a1\u7ed3\u6784\u503c\u5931\u8d25, fieldName: {}, fieldValue: {}", new Object[]{name, struct, e});
                }
                continue;
            }
            cf = COMMON_COLUMN_FAMILY;
            byte[] bytes = result.getValue(cf.getBytes(), name.getBytes());
            if (bytes == null || bytes.length <= 0) continue;
            try {
                field.set(po, DataTypeEnum.getEnumByType(field.getType()).bytes2Object(bytes));
            }
            catch (IllegalAccessException e) {
                this.log.error("\u8bbe\u7f6e\u901a\u7528\u5b57\u6bb5\u503c\u5931\u8d25, fieldName: {}, fieldValue: {}", new Object[]{name, bytes, e});
            }
        }
        return po;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BusinessRecord> handleScanner(ResultScanner resultScanner) {
        if (resultScanner == null) {
            return null;
        }
        LinkedList<BusinessRecord> list = new LinkedList<BusinessRecord>();
        try {
            for (Result result : resultScanner) {
                if (result == null) continue;
                list.add(this.handleResult(result));
            }
        }
        finally {
            resultScanner.close();
        }
        return list;
    }

    private void put(List<BusinessRecord> records) {
        for (BusinessRecord record : records) {
            String tableName = this.getTableName(record.getAppId());
            if (!this.tableExistsOrCreate(tableName)) continue;
            try {
                Table table = this.connection.getTable(TableName.valueOf((String)tableName));
                Throwable throwable = null;
                try {
                    if (record == null) continue;
                    table.put(this.convertVO2Put(record));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (table == null) continue;
                    if (throwable != null) {
                        try {
                            table.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    table.close();
                }
            }
            catch (IOException e) {
                this.log.error("\u64cd\u4f5c\u8bb0\u5f55\u5931\u8d25, id: {}, appId: {}", new Object[]{record.getId(), record.getAppId(), e});
            }
        }
    }

    private CompareFilter.CompareOp getCompareOp(CriteriaOperatorEnum operator) {
        CompareFilter.CompareOp rt = null;
        switch (operator) {
            case EQ: {
                rt = CompareFilter.CompareOp.EQUAL;
                break;
            }
            case NE: {
                rt = CompareFilter.CompareOp.NOT_EQUAL;
                break;
            }
            case LT: {
                rt = CompareFilter.CompareOp.LESS;
                break;
            }
            case GT: {
                rt = CompareFilter.CompareOp.GREATER;
                break;
            }
            case LE: {
                rt = CompareFilter.CompareOp.LESS_OR_EQUAL;
                break;
            }
            case GE: {
                rt = CompareFilter.CompareOp.GREATER_OR_EQUAL;
            }
        }
        return rt;
    }

    public HBaseBusinessRecordDao() {
    }

    public HBaseBusinessRecordDao(String zookeeperQuorum, String zookeeperPropertyClientPort, long maxPageSize) {
        this.zookeeperQuorum = zookeeperQuorum;
        this.zookeeperPropertyClientPort = zookeeperPropertyClientPort;
        this.maxPageSize = maxPageSize;
    }

    @Override
    public List<String> getBusinessNameList(String appId) {
        return null;
    }

    @Override
    public void create(BusinessRecord record) {
        if (record == null) {
            return;
        }
        record.setId(null);
        record.setCreateTime(new Date());
        record.setUpdateTime(new Date());
        this.put(Collections.singletonList(record));
    }

    @Override
    public long update(BusinessRecord record) {
        return this.batchUpdate(Lists.newArrayList((Object[])new BusinessRecord[]{record}));
    }

    @Override
    public long batchUpdate(List<BusinessRecord> records) {
        if (CollectionUtils.isEmpty(records)) {
            return 0L;
        }
        Iterator<BusinessRecord> iterator = records.iterator();
        while (iterator.hasNext()) {
            BusinessRecord record = iterator.next();
            if (record.getId() == null) {
                iterator.remove();
                continue;
            }
            record.setUpdateTime(new Date());
        }
        this.put(records);
        return 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BusinessRecord getById(String appId, String bizName, String id) {
        String tableName = this.getTableName(appId);
        if (!this.tableExists(tableName)) {
            return null;
        }
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            Get get = new Get(DataTypeEnum.getEnumByType(id.getClass()).object2Bytes((Object)id));
            BusinessRecord businessRecord = this.handleResult(table.get(get));
            return businessRecord;
        }
        catch (IOException e) {
            this.log.error("\u6839\u636erowKey\u67e5\u8be2\u8bb0\u5f55\u5931\u8d25, appId: {}, id: {}", new Object[]{appId, id, e});
            return null;
        }
    }

    private void setFilterList(FilterList filterList, List<CriteriaNode> children) {
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (CriteriaNode criteria : children) {
            this.setFilterList(filterList, criteria);
        }
    }

    private void setFilterList(FilterList filterList, CriteriaNode criteria) {
        switch (criteria.getOp()) {
            case AND: {
                FilterList subFilterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
                this.setFilterList(subFilterList, criteria.getChildren());
                if (!CollectionUtils.isNotEmpty((Collection)subFilterList.getFilters())) break;
                filterList.addFilter((Filter)subFilterList);
                break;
            }
            case OR: {
                FilterList subFilterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
                this.setFilterList(subFilterList, criteria.getChildren());
                if (!CollectionUtils.isNotEmpty((Collection)subFilterList.getFilters())) break;
                filterList.addFilter((Filter)subFilterList);
                break;
            }
            case IN: {
                FilterList subFilterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
                Object condition = criteria.getValue();
                if (!(condition instanceof Iterable)) {
                    throw new RuntimeException("[DATAHUB] \u8bed\u6cd5\u9519\u8bef\uff1a\u5bf9\u4e8e\u8868\u8fbe\u5f0f'" + String.valueOf(condition) + "' \u4e0d\u80fd\u7528\u64cd\u4f5c\u7b26 'in'!");
                }
                Iterable iterable = (Iterable)condition;
                for (Object value : iterable) {
                    subFilterList.addFilter((Filter)new SingleColumnValueFilter(this.getFilterColumnFamily(criteria).getBytes(), this.getFilterColumnKey(criteria.getKey()).getBytes(), CompareFilter.CompareOp.EQUAL, this.getFilterCondBytes(value)));
                }
                if (!CollectionUtils.isNotEmpty((Collection)subFilterList.getFilters())) break;
                filterList.addFilter((Filter)subFilterList);
                break;
            }
            default: {
                filterList.addFilter((Filter)new SingleColumnValueFilter(this.getFilterColumnFamily(criteria).getBytes(), this.getFilterColumnKey(criteria.getKey()).getBytes(), this.getCompareOp(criteria.getOp()), this.getFilterCondBytes(criteria.getValue())));
            }
        }
    }

    private boolean isCommonColumnKey(String key) {
        return key.startsWith("$");
    }

    private String getFilterColumnFamily(CriteriaNode criteria) {
        if (this.isCommonColumnKey(criteria.getKey())) {
            return COMMON_COLUMN_FAMILY;
        }
        return BIZ_COLUMN_FAMILY;
    }

    private byte[] getFilterCondBytes(Object value) {
        if (value == null) {
            return null;
        }
        DataTypeEnum dataTypeEnum = DataTypeEnum.getEnumByType(value.getClass());
        if (dataTypeEnum == null) {
            return null;
        }
        return dataTypeEnum.object2Bytes(value);
    }

    private String getFilterColumnKey(String key) {
        if (this.isCommonColumnKey(key)) {
            return key.substring(1);
        }
        return key;
    }

    private ResultScanner getPageData(String tableName, String appId, String bizName, QuerySupport querySupport) {
        querySupport = (QuerySupport)BeanUtil.buildFrom((Object)querySupport, QuerySupport.class);
        this.setStartRowKey(tableName, appId, bizName, querySupport);
        ResultScanner scanner = this.getData(tableName, appId, bizName, querySupport);
        return scanner;
    }

    public void setStartRowKey(String tableName, String appId, String bizName, QuerySupport querySupport) {
        Long pageNum = querySupport.getPage();
        if (pageNum == null || pageNum <= 1L) {
            return;
        }
        int i = 1;
        while ((long)i < pageNum) {
            Result next2 = null;
            ResultScanner scanner = this.getData(tableName, appId, bizName, querySupport);
            for (Result next2 : scanner) {
            }
            if (next2 == null || Bytes.toLong((byte[])next2.getRow()) == querySupport.getStartRowKey()) {
                return;
            }
            querySupport.setStartRowKey(Bytes.toLong((byte[])next2.getRow()));
            ++i;
        }
    }

    private void setQueryConditions(Scan scan, String bizName, QuerySupport querySupport) {
        if (querySupport.getStartRowKey() != null) {
            scan.setStartRow(DataTypeEnum.LONG.object2Bytes((Object)querySupport.getStartRowKey()));
        }
        FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        if (StringUtils.isNotBlank((CharSequence)bizName)) {
            filterList.addFilter((Filter)new SingleColumnValueFilter(COMMON_COLUMN_FAMILY.getBytes(), BIZ_STRUCT_NAME.getBytes(), CompareFilter.CompareOp.EQUAL, bizName.getBytes()));
        }
        if (querySupport != null) {
            this.setFilterList(filterList, querySupport.getCriteriaNode());
        }
        filterList.addFilter((Filter)new PageFilter(querySupport.getPageSize() + 1L));
        scan.setFilter((Filter)filterList);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ResultScanner getData(String tableName, String appId, String bizName, QuerySupport querySupport) {
        Scan scan = new Scan();
        this.setQueryConditions(scan, bizName, querySupport);
        Boolean reversed = querySupport.getReversed();
        if (reversed != null && reversed.booleanValue()) {
            scan.setReversed(true);
        }
        try (Table table = this.connection.getTable(TableName.valueOf((String)tableName));){
            ResultScanner resultScanner = table.getScanner(scan);
            return resultScanner;
        }
        catch (IOException e) {
            this.log.error("\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u5931\u8d25, appId: {}, query: {}", new Object[]{appId, JSON.toJSONString((Object)querySupport), e});
            if (!(e instanceof TableNotFoundException)) return null;
            throw new DatahubQueryException(querySupport, "\u4e0d\u5b58\u5728\u8868 \"" + e.getLocalizedMessage() + "\"");
        }
    }

    @Override
    public Long count(String appId, String bizName, QuerySupport querySupport) {
        String tableName = this.getTableName(appId);
        if (!this.tableExists(tableName)) {
            return null;
        }
        Scan scan = new Scan();
        this.setQueryConditions(scan, bizName, querySupport);
        if (querySupport.getHasCount() != null && querySupport.getHasCount().booleanValue()) {
            try {
                Long rowCount = this.aggregationClient.rowCount(TableName.valueOf((String)tableName), (ColumnInterpreter)new LongColumnInterpreter(), scan);
                return rowCount;
            }
            catch (Throwable e) {
                this.log.error("\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u6570\u91cf\u5931\u8d25, appId: {}, query: {}", new Object[]{appId, JSON.toJSONString((Object)querySupport), e});
            }
        }
        return null;
    }

    @Override
    public QueryResult<BusinessRecord> find(String appId, String bizName, QuerySupport querySupport) {
        List<BusinessRecord> list;
        String tableName = this.getTableName(appId);
        if (!this.tableExists(tableName)) {
            throw new DatahubQueryException(querySupport, "\u4e0d\u5b58\u5728\u8868 \"" + tableName + "\"");
        }
        if (querySupport.getPage() == null) {
            querySupport.setPage(1L);
        }
        long actualPageSize = this.getActualPageSize(querySupport.getPageSize());
        querySupport.setPageSize(actualPageSize);
        LinkedList<BusinessRecord> totalRecords = new LinkedList<BusinessRecord>();
        String nextId = null;
        ResultScanner scanner = this.getPageData(tableName, appId, bizName, querySupport);
        try {
            list = this.handleScanner(scanner);
        }
        catch (Throwable e) {
            this.log.error("\u6761\u4ef6\u67e5\u8be2\u8bb0\u5f55\u5931\u8d25, appId: {}, query: {}", new Object[]{appId, JSON.toJSONString((Object)querySupport), e});
            throw new DatahubQueryException(querySupport, e);
        }
        for (BusinessRecord item : list) {
            if ((long)totalRecords.size() < actualPageSize) {
                totalRecords.add(item);
                continue;
            }
            nextId = item.getId();
        }
        QueryResult result = new QueryResult();
        result.setPage(querySupport.getPage());
        result.setPageSize(Long.valueOf(actualPageSize));
        if (querySupport.getHasCount() != null && querySupport.getHasCount().booleanValue()) {
            Long totalCount = this.count(appId, bizName, querySupport);
            result.setTotalCount(totalCount.longValue());
        }
        if (nextId != null) {
            result.setNextId(nextId);
            result.setHasNextPage(Boolean.valueOf(true));
        }
        result.setData(totalRecords);
        return result;
    }

    @Override
    public QueryResult<BusinessRecord> findDistinct(String appId, String bizName, String fieldName, QuerySupport querySupport) {
        return null;
    }

    @Override
    public List<AggregationResult> aggregate(String appId, String bizName, AggregationSupport aggregationSupport) {
        return null;
    }

    @Override
    public void startTransaction() {
    }
}

