/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.bgel.runtime.BgelRange;
import com.thebeastshop.datahub.client.criteria.Criteria;
import com.thebeastshop.datahub.client.criteria.Group;
import com.thebeastshop.datahub.client.criteria.GroupItem;
import com.thebeastshop.datahub.client.criteria.Query;
import com.thebeastshop.datahub.common.dto.AggregateNode;
import com.thebeastshop.datahub.common.dto.CriteriaNode;
import com.thebeastshop.datahub.common.dto.GroupItemNode;
import com.thebeastshop.datahub.common.dto.GroupNode;
import com.thebeastshop.datahub.common.dto.QueryNode;
import com.thebeastshop.datahub.common.enums.CriteriaOperatorEnum;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class CriteriaUtils {
    public static QueryNode toQueryNode(Query query) {
        QueryNode node = new QueryNode();
        node.setEl(query.getEl());
        node.setStartRowKey(query.getStartRow());
        node.setPage(query.getPage());
        node.setPageSize(query.getPageSize());
        node.setReversed(Boolean.valueOf(query.isReversed()));
        node.setSort(query.getSort());
        node.setHasCount(Boolean.valueOf(query.hasCount()));
        return node;
    }

    public static GroupNode toGroupNode(Group group) {
        GroupNode groupNode = new GroupNode();
        groupNode.setGroupByKeys((List)Lists.newArrayList((Object[])group.getGroupByKeys()));
        Map<String, GroupItem> itemMap = group.getGroupItems();
        LinkedHashMap<String, GroupItemNode> itemNodeMap = new LinkedHashMap<String, GroupItemNode>();
        for (Map.Entry<String, GroupItem> entry : itemMap.entrySet()) {
            String key = entry.getKey();
            GroupItem item = entry.getValue();
            GroupItemNode itemNode = new GroupItemNode();
            itemNode.setAlias(item.getAlias());
            itemNode.setArg(item.getArg());
            itemNode.setFunction(item.getFunction());
            itemNodeMap.put(key, itemNode);
        }
        groupNode.setItems(itemNodeMap);
        return groupNode;
    }

    public static AggregateNode toAggregateNode(Query query, Group[] groups) {
        AggregateNode aggregateNode = new AggregateNode();
        QueryNode queryNode = CriteriaUtils.toQueryNode(query);
        ArrayList<GroupNode> groupList = new ArrayList<GroupNode>(groups.length);
        for (Group group : groups) {
            GroupNode groupNode = CriteriaUtils.toGroupNode(group);
            groupList.add(groupNode);
        }
        aggregateNode.setQueryNode(queryNode);
        aggregateNode.setGroupNodes(groupList);
        return aggregateNode;
    }

    public static CriteriaNode toCriteriaNode(Criteria criteria) {
        CriteriaNode node = new CriteriaNode();
        CriteriaUtils.setupNode(node, criteria);
        Criteria right = criteria.getRight();
        List<Criteria> chain = criteria.getCriteriaChain();
        if (criteria.getOp() == CriteriaOperatorEnum.OR) {
            node.setKey(null);
            node.setValue(null);
            LinkedList<CriteriaNode> nodeList = new LinkedList<CriteriaNode>();
            for (Criteria orItem : chain) {
                CriteriaNode orNode = CriteriaUtils.toCriteriaNode(orItem);
                nodeList.add(orNode);
            }
            node.setChildren(nodeList);
        }
        if (right == null) {
            return node;
        }
        if (criteria == criteria.getHead()) {
            CriteriaNode andNode = new CriteriaNode();
            andNode.setOp(CriteriaOperatorEnum.AND);
            LinkedList<CriteriaNode> nodeList = new LinkedList<CriteriaNode>();
            nodeList.add(node);
            while (right != null) {
                CriteriaNode childNode = CriteriaUtils.toCriteriaNode(right);
                nodeList.add(childNode);
                right = right.getRight();
            }
            andNode.setChildren(nodeList);
            return andNode;
        }
        return node;
    }

    private static CriteriaNode setupNode(CriteriaNode node, Criteria criteria) {
        node.setKey(criteria.getKey());
        node.setOp(criteria.getOp());
        node.setValue(criteria.getValue());
        return node;
    }

    public static String toELString(CriteriaNode criteriaNode) {
        if (criteriaNode == null) {
            return null;
        }
        CriteriaOperatorEnum op = criteriaNode.getOp();
        String key = criteriaNode.getKey();
        switch (op) {
            case AND: {
                return CriteriaUtils.joinChildrenToEL(criteriaNode, "and");
            }
            case OR: {
                return CriteriaUtils.joinChildrenToEL(criteriaNode, "or");
            }
            case NOT: {
                return "not " + CriteriaUtils.valueToEL(criteriaNode);
            }
            case LT: {
                return key + "<" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case GT: {
                return key + ">" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case LE: {
                return key + "<=" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case GE: {
                return key + ">=" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case EQ: {
                return key + "==" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case NE: {
                return key + "!=" + CriteriaUtils.valueToEL(criteriaNode);
            }
            case IN: {
                return key + " in " + CriteriaUtils.valueToEL(criteriaNode);
            }
            case NOT_IN: {
                return key + " !in " + CriteriaUtils.valueToEL(criteriaNode);
            }
            case REGEX_MATCH: {
                return key + " =~ " + CriteriaUtils.valueToEL(criteriaNode);
            }
            case NOT_REGEX_MATCH: {
                return key + " !=~ " + CriteriaUtils.valueToEL(criteriaNode);
            }
        }
        throw new RuntimeException("[DataHub] Operator '" + op + "' is not supported!");
    }

    public static String valueToEL(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Long) {
            return value + "L";
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return format.format(value);
        }
        if (value instanceof BgelRange) {
            return CriteriaUtils.rangeToString((BgelRange)value);
        }
        if (value instanceof List) {
            StringBuilder builder = new StringBuilder("[");
            Iterator iter = ((List)value).iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                String itemEL = CriteriaUtils.valueToEL(item);
                builder.append(itemEL);
                if (!iter.hasNext()) continue;
                builder.append(",");
            }
            builder.append("]");
            return builder.toString();
        }
        if (value instanceof Map) {
            return JSON.toJSONString((Object)value);
        }
        if (value instanceof Pattern) {
            Pattern pattern = (Pattern)value;
            StringBuilder builder = new StringBuilder("/").append(pattern.pattern()).append("/");
            int flags = pattern.flags();
            if ((flags & 2) != 0) {
                builder.append("i");
            }
            if ((flags & 8) != 0) {
                builder.append("m");
            }
            if ((flags & 4) != 0) {
                builder.append("x");
            }
            if ((flags & 0x20) != 0) {
                builder.append("s");
            }
            return builder.toString();
        }
        return JSON.toJSONString((Object)value.toString());
    }

    private static String rangeToString(BgelRange range) {
        StringBuilder builder = new StringBuilder();
        builder.append(range.isIncludeFrom() ? (char)'[' : '(');
        if (range.getFrom() != null) {
            builder.append(CriteriaUtils.valueToEL(range.getFrom()));
        } else {
            builder.append(' ');
        }
        builder.append("..");
        if (range.getTo() != null) {
            builder.append(CriteriaUtils.valueToEL(range.getTo()));
        } else {
            builder.append(' ');
        }
        builder.append(range.isIncludeTo() ? (char)']' : ')');
        return builder.toString();
    }

    private static String valueToEL(CriteriaNode criteriaNode) {
        return CriteriaUtils.valueToEL(criteriaNode.getValue());
    }

    private static String joinChildrenToEL(CriteriaNode criteriaNode, String op) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        List children = criteriaNode.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            String childEl = CriteriaUtils.toELString((CriteriaNode)children.get(i));
            builder.append(childEl);
            if (i >= children.size() - 1) continue;
            builder.append(' ');
            builder.append(op);
            builder.append(' ');
        }
        builder.append(")");
        return builder.toString();
    }

    public static String adjustElWithArgs(String el, Object ... args) {
        if (args != null && args.length > 0) {
            Object[] elArgs = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                elArgs[i] = CriteriaUtils.valueToEL(args[i]);
            }
            String parsedEl = MessageFormat.format(el, elArgs);
            return parsedEl;
        }
        return el;
    }

    public static void main(String[] args) {
        System.out.println(CriteriaUtils.valueToEL(123));
    }
}

