/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.thebeastshop.datahub.client.kafka.ResponseMessageListener;
import com.thebeastshop.datahub.common.vo.ResponseMessage;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ResponseFuture
implements Future<ResponseMessage> {
    private final String transId;
    private final ResponseMessageListener listener;
    private volatile ResponseMessage response;
    private volatile boolean isDone;
    private boolean isCancelled;

    public ResponseFuture(String transId, ResponseMessageListener listener) {
        this.transId = transId;
        this.listener = listener;
        this.isDone = false;
        this.isCancelled = false;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.listener.removeCachedCallback(this.transId);
        this.isCancelled = true;
        return false;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    public synchronized void set(ResponseMessage message) {
        this.response = message;
        this.isDone = true;
        this.notifyAll();
    }

    @Override
    public boolean isDone() {
        return this.isDone;
    }

    private boolean awaitDone(boolean timed, long nanos) throws InterruptedException {
        long deadline;
        long l = deadline = timed ? System.nanoTime() + nanos : 0L;
        while (true) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.isDone) {
                return this.isDone;
            }
            if (timed) {
                nanos = deadline - System.nanoTime();
                if (nanos <= 0L) {
                    return this.isDone;
                }
                this.wait(1L);
                continue;
            }
            this.wait();
        }
    }

    @Override
    public synchronized ResponseMessage get() throws InterruptedException {
        this.awaitDone(false, 0L);
        return this.response;
    }

    @Override
    public synchronized ResponseMessage get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        if (unit == null) {
            throw new NullPointerException();
        }
        if (!this.isDone && !this.awaitDone(true, unit.toNanos(timeout))) {
            this.listener.removeCachedCallback(this.transId);
            throw new TimeoutException("[DATAHUB] \u7b49\u5f85\u54cd\u5e94\u6d88\u606f\u8d85\u65f6");
        }
        return this.response;
    }
}

