/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.datahub.client.utils;

import com.thebeastshop.datahub.client.exception.DatahubHostException;
import com.thebeastshop.datahub.common.dto.HostDTO;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;

public class HostUtil {
    private static HostDTO localHost = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HostDTO getLocalHost() {
        if (localHost != null) return localHost;
        Class<HostUtil> clazz = HostUtil.class;
        synchronized (HostUtil.class) {
            if (localHost != null) return localHost;
            InetAddress ia = null;
            try {
                ia = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                throw new DatahubHostException(e);
            }
            String port = System.getProperty("server.port");
            if (StringUtils.isBlank((CharSequence)port) && StringUtils.isBlank((CharSequence)(port = System.getProperty("dubbo.port")))) {
                port = "-1";
            }
            localHost = HostDTO.fromAddress((InetAddress)ia, (String)port);
            // ** MonitorExit[var0] (shouldn't be in output)
            return localHost;
        }
    }
}

